/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.spi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.spi.EventMeshSPI;
import org.apache.eventmesh.spi.ExtensionException;
import org.apache.eventmesh.spi.loader.ExtensionClassLoader;
import org.apache.eventmesh.spi.loader.JarExtensionClassLoader;
import org.apache.eventmesh.spi.loader.MetaInfExtensionClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(EventMeshExtensionFactory.class);
    private static final List<ExtensionClassLoader> EXTENSION_CLASS_LOADERS = new ArrayList<ExtensionClassLoader>();
    private static final ConcurrentHashMap<String, Object> EXTENSION_INSTANCE_CACHE = new ConcurrentHashMap(16);

    private EventMeshExtensionFactory() {
    }

    public static <T> T getExtension(Class<T> extensionType, String extensionName) {
        if (extensionType == null) {
            throw new ExtensionException("extensionType is null");
        }
        if (StringUtils.isEmpty((CharSequence)extensionName)) {
            throw new ExtensionException("extensionName is null");
        }
        if (!extensionType.isInterface() || !extensionType.isAnnotationPresent(EventMeshSPI.class)) {
            throw new ExtensionException(String.format("extensionType:%s is invalided", extensionType));
        }
        EventMeshSPI eventMeshSPIAnnotation = extensionType.getAnnotation(EventMeshSPI.class);
        if (eventMeshSPIAnnotation.isSingleton()) {
            return EventMeshExtensionFactory.getSingletonExtension(extensionType, extensionName);
        }
        return EventMeshExtensionFactory.getPrototypeExtension(extensionType, extensionName);
    }

    private static <T> T getSingletonExtension(Class<T> extensionType, String extensionInstanceName) {
        return (T)EXTENSION_INSTANCE_CACHE.computeIfAbsent(extensionInstanceName, name -> {
            Class extensionInstanceClass = EventMeshExtensionFactory.getExtensionInstanceClass(extensionType, extensionInstanceName);
            if (extensionInstanceClass == null) {
                return null;
            }
            try {
                Object extensionInstance = extensionInstanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigService.getInstance().populateConfigForObject(extensionInstance);
                log.info("initialize extension instance success, extensionType: {}, extensionInstanceName: {}", (Object)extensionType, (Object)extensionInstanceName);
                return extensionInstance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExtensionException("Extension initialize error", e);
            }
            catch (IOException | NoSuchFieldException e) {
                log.error("initialize extension instance config failed, extensionType: {}, extensionInstanceName: {}", new Object[]{extensionType, extensionInstanceName, e});
                throw new ExtensionException("Extension initialize error", e);
            }
        });
    }

    private static <T> T getPrototypeExtension(Class<T> extensionType, String extensionInstanceName) {
        Class<T> extensionInstanceClass = EventMeshExtensionFactory.getExtensionInstanceClass(extensionType, extensionInstanceName);
        if (extensionInstanceClass == null) {
            return null;
        }
        try {
            T extensionInstance = extensionInstanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigService.getInstance().populateConfigForObject(extensionInstance);
            log.info("initialize extension instance success, extensionType: {}, extensionName: {}", extensionType, (Object)extensionInstanceName);
            return extensionInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExtensionException("Extension initialize error", e);
        }
        catch (IOException | NoSuchFieldException e) {
            log.error("initialize extension instance config failed, extensionType: {}, extensionInstanceName: {}", new Object[]{extensionType, extensionInstanceName, e});
            throw new ExtensionException("Extension initialize error", e);
        }
    }

    private static <T> Class<T> getExtensionInstanceClass(Class<T> extensionType, String extensionInstanceName) {
        for (ExtensionClassLoader extensionClassLoader : EXTENSION_CLASS_LOADERS) {
            Map<String, Class<?>> extensionInstanceClassMap = extensionClassLoader.loadExtensionClass(extensionType, extensionInstanceName);
            Class<?> instanceClass = extensionInstanceClassMap.get(extensionInstanceName);
            if (instanceClass == null) continue;
            return instanceClass;
        }
        return null;
    }

    static {
        EXTENSION_CLASS_LOADERS.add(MetaInfExtensionClassLoader.getInstance());
        EXTENSION_CLASS_LOADERS.add(JarExtensionClassLoader.getInstance());
    }
}

