/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import type * as playwright from 'playwright-chromium';

import { QueryOverview } from './component/query/overview';
import { saveScreenshotIfError } from './util/debug';
import { UNIFIED_CONSOLE_URL } from './util/druid';
import { createBrowser, createPage } from './util/playwright';
import { waitTillWebConsoleReady } from './util/setup';

jest.setTimeout(5 * 60 * 1000);

describe('Cancel query', () => {
  let browser: playwright.Browser;
  let page: playwright.Page;

  beforeAll(async () => {
    await waitTillWebConsoleReady();
    browser = await createBrowser();
  });

  beforeEach(async () => {
    page = await createPage(browser);
  });

  afterAll(async () => {
    await browser.close();
  });

  it('delete accepted', async () => {
    const testName = 'cancel-query';
    await saveScreenshotIfError(testName, page, async () => {
      await validateCancelQuery(page);
    });
  });
});

async function validateCancelQuery(page: playwright.Page) {
  const queryOverview = new QueryOverview(page, UNIFIED_CONSOLE_URL);
  const query = 'SELECT sleep(40)';
  const results = await queryOverview.cancelQuery(query);
  expect(results).toBeDefined();
  expect(results).toBeGreaterThan(0);
  expect(results).toStrictEqual(202);
}
