/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ErrorPage
extends FormPage {
    public static final String ID = ErrorPage.class.getName();
    private static final String TITLE = Messages.getString("ErrorPage.ErrorOpeningEditor");
    private static final String DETAILS_CLOSED = NLS.bind((String)"{0} >>", (Object)Messages.getString("ErrorPage.Details"));
    private static final String DETAILS_OPEN = NLS.bind((String)"<< {0}", (Object)Messages.getString("ErrorPage.Details"));
    private Exception exception;
    private boolean detailsShown = false;
    private FormToolkit toolkit;
    private Composite parent;
    private Button detailsButton;
    private Text detailsText;

    public ErrorPage(FormEditor editor, Exception exception) {
        super(editor, ID, TITLE);
        this.exception = exception;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(Messages.getString("ErrorPage.ErrorOpeningEditor"));
        form.setImage(Display.getCurrent().getSystemImage(1));
        this.parent = form.getBody();
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.parent.setLayout((Layout)gl);
        this.parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.toolkit = managedForm.getToolkit();
        this.toolkit.decorateFormHeading(form.getForm());
        Label errorLabel = this.toolkit.createLabel(this.parent, "");
        errorLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.detailsButton = new Button(this.parent, 8);
        this.detailsButton.setText(DETAILS_CLOSED);
        this.detailsButton.setLayoutData((Object)new GridData(131072, 0, false, false));
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorPage.this.showOrHideDetailsView();
            }
        });
        if (this.exception == null) {
            errorLabel.setText(Messages.getString("ErrorPage.CouldNotOpenEditor"));
            this.detailsButton.setVisible(false);
        } else {
            errorLabel.setText(NLS.bind((String)"Could not open the editor: {0}", (Object)this.exception.getMessage()));
        }
    }

    private void showOrHideDetailsView() {
        if (this.detailsShown) {
            this.detailsButton.setText(DETAILS_CLOSED);
            this.detailsText.dispose();
        } else {
            this.detailsButton.setText(DETAILS_OPEN);
            this.detailsText = this.toolkit.createText(this.parent, this.getStackTrace(this.exception), 768);
            this.detailsText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        }
        this.parent.layout(true, true);
        this.detailsShown = !this.detailsShown;
    }

    private String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }
}

