/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import jdbm.RecordManager;
import jdbm.helper.ByteArraySerializer;
import jdbm.helper.Serializer;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.StringSerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.UuidSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmIndex<K>
extends AbstractIndex<K, String> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmIndex.class);
    public static final int DEFAULT_DUPLICATE_LIMIT = 512;
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    protected JdbmTable<K, String> forward;
    protected JdbmTable<String, K> reverse;
    protected RecordManager recMan;
    protected int numDupLimit = 512;
    protected File wkDirPath;

    public JdbmIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
        this.initialized = false;
    }

    public void init(RecordManager recMan, SchemaManager schemaManager, AttributeType attributeType) throws LdapException, IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        String cacheSizeVal = System.getProperty("jdbm.recman.cache.size", "100");
        int recCacheSize = Integer.parseInt(cacheSizeVal);
        LOG.info("Setting CacheRecondManager's cache size to {}", (Object)recCacheSize);
        this.recMan = recMan;
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close(null);
            throw e;
        }
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        SerializableComparator comp = new SerializableComparator(mr.getOid());
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        comp.setSchemaManager(schemaManager);
        this.forward = mr.getSyntax().isHumanReadable() ? new JdbmTable(schemaManager, this.attributeType.getOid() + FORWARD_BTREE, this.numDupLimit, this.recMan, comp, UuidComparator.INSTANCE, StringSerializer.INSTANCE, UuidSerializer.INSTANCE) : new JdbmTable(schemaManager, this.attributeType.getOid() + FORWARD_BTREE, this.numDupLimit, this.recMan, comp, UuidComparator.INSTANCE, (Serializer)new ByteArraySerializer(), UuidSerializer.INSTANCE);
        if (this.withReverse) {
            this.reverse = this.attributeType.isSingleValued() ? new JdbmTable(schemaManager, this.attributeType.getOid() + REVERSE_BTREE, this.recMan, UuidComparator.INSTANCE, UuidSerializer.INSTANCE, null) : new JdbmTable(schemaManager, this.attributeType.getOid() + REVERSE_BTREE, this.numDupLimit, this.recMan, UuidComparator.INSTANCE, comp, UuidSerializer.INSTANCE, null);
        }
    }

    public int getNumDupLimit() {
        return this.numDupLimit;
    }

    public void setNumDupLimit(int numDupLimit) {
        this.protect("numDupLimit");
        this.numDupLimit = numDupLimit;
    }

    public void setWkDirPath(URI wkDirPath) {
        this.protect("wkDirPath");
        this.wkDirPath = new File(wkDirPath);
    }

    public URI getWkDirPath() {
        return this.wkDirPath != null ? this.wkDirPath.toURI() : null;
    }

    public long count(PartitionTxn partitionTxn) throws LdapException {
        return this.forward.count(partitionTxn);
    }

    public long count(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.count(partitionTxn, attrVal);
    }

    public long greaterThanCount(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.greaterThanCount(partitionTxn, attrVal);
    }

    public long lessThanCount(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.lessThanCount(partitionTxn, attrVal);
    }

    public String forwardLookup(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.get(partitionTxn, attrVal);
    }

    public K reverseLookup(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.get(partitionTxn, id);
        }
        return null;
    }

    public synchronized void add(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        this.forward.put(partitionTxn, attrVal, id);
        if (this.withReverse) {
            this.reverse.put(partitionTxn, id, (String)attrVal);
        }
    }

    public synchronized void drop(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        if (this.forward.has(partitionTxn, attrVal, id)) {
            this.forward.remove(partitionTxn, attrVal, id);
            if (this.withReverse) {
                this.reverse.remove(partitionTxn, id, (String)attrVal);
            }
        }
    }

    public void drop(PartitionTxn partitionTxn, String entryId) throws LdapException {
        if (this.withReverse) {
            if (this.isDupsEnabled()) {
                Cursor<Tuple<String, K>> values = this.reverse.cursor(partitionTxn, entryId);
                try {
                    while (values.next()) {
                        this.forward.remove(partitionTxn, ((Tuple)values.get()).getValue(), entryId);
                    }
                    values.close();
                }
                catch (IOException | CursorException e) {
                    throw new LdapOtherException(e.getMessage(), e);
                }
            } else {
                K key = this.reverse.get(partitionTxn, entryId);
                this.forward.remove(partitionTxn, key);
            }
            this.reverse.remove(partitionTxn, entryId);
        }
    }

    public Cursor<IndexEntry<K, String>> forwardCursor(PartitionTxn partitionTxn) throws LdapException {
        return new IndexCursorAdaptor(partitionTxn, this.forward.cursor(), true);
    }

    public Cursor<IndexEntry<K, String>> forwardCursor(PartitionTxn partitionTxn, K key) throws LdapException {
        return new IndexCursorAdaptor(partitionTxn, this.forward.cursor(partitionTxn, key), true);
    }

    public Cursor<K> reverseValueCursor(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.valueCursor(partitionTxn, id);
        }
        return new EmptyCursor();
    }

    public Cursor<String> forwardValueCursor(PartitionTxn partitionTxn, K key) throws LdapException {
        return this.forward.valueCursor(partitionTxn, key);
    }

    public boolean forward(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.has(partitionTxn, attrVal);
    }

    public boolean forward(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        return this.forward.has(partitionTxn, attrVal, id);
    }

    public boolean reverse(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.has(partitionTxn, id);
        }
        return false;
    }

    public boolean reverse(PartitionTxn partitionTxn, String id, K attrVal) throws LdapException {
        return this.forward.has(partitionTxn, attrVal, id);
    }

    public synchronized void close(PartitionTxn partitionTxn) throws LdapException, IOException {
        if (this.forward != null) {
            this.forward.close(partitionTxn);
        }
        if (this.reverse != null) {
            this.reverse.close(partitionTxn);
        }
    }

    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    public String toString() {
        return "Index<" + this.attributeId + ">";
    }
}

