/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.ContentTypeSpecializationComparator;
import org.eclipse.ui.internal.genericeditor.GenericContentTypeRelatedExtension;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReconcilerRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.reconcilers";
    private static final String HIGHLIGHT_EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.highlightReconcilers";
    private static final String FOLDING_EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.foldingReconcilers";
    private Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> extensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>>();
    private Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> highlightExtensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>>();
    private Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> foldingExtensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>>();
    private boolean outOfSync = true;
    private boolean highlightOutOfSync = true;
    private boolean foldingOutOfSync = true;

    public ReconcilerRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.outOfSync = true;
        }, EXTENSION_POINT_ID);
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.highlightOutOfSync = true;
        }, HIGHLIGHT_EXTENSION_POINT_ID);
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.foldingOutOfSync = true;
        }, FOLDING_EXTENSION_POINT_ID);
    }

    public List<IReconciler> getReconcilers(ISourceViewer sourceViewer, ITextEditor editor, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        return this.extensions.values().stream().filter(ext -> contentTypes.contains(ext.targetContentType)).filter(ext -> ext.matches(sourceViewer, editor)).sorted(new ContentTypeSpecializationComparator().reversed()).map(GenericContentTypeRelatedExtension::createDelegate).collect(Collectors.toList());
    }

    public List<IReconciler> getHighlightReconcilers(ISourceViewer sourceViewer, ITextEditor editor, Set<IContentType> contentTypes) {
        if (this.highlightOutOfSync) {
            this.syncHighlight();
        }
        return this.highlightExtensions.values().stream().filter(ext -> contentTypes.contains(ext.targetContentType)).filter(ext -> ext.matches(sourceViewer, editor)).sorted(new ContentTypeSpecializationComparator().reversed()).map(GenericContentTypeRelatedExtension::createDelegate).collect(Collectors.toList());
    }

    public List<IReconciler> getFoldingReconcilers(ISourceViewer sourceViewer, ITextEditor editor, Set<IContentType> contentTypes) {
        if (this.foldingOutOfSync) {
            this.syncFolding();
        }
        return this.foldingExtensions.values().stream().filter(ext -> contentTypes.contains(ext.targetContentType)).filter(ext -> ext.matches(sourceViewer, editor)).sorted(new ContentTypeSpecializationComparator().reversed()).map(GenericContentTypeRelatedExtension::createDelegate).collect(Collectors.toList());
    }

    private void sync() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.extensions.containsKey(extension)) {
                try {
                    this.extensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }

    private void syncHighlight() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(HIGHLIGHT_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.highlightExtensions.containsKey(extension)) {
                try {
                    this.highlightExtensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.highlightExtensions.remove(toRemove);
        }
        this.highlightOutOfSync = false;
    }

    private void syncFolding() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(FOLDING_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.foldingExtensions.containsKey(extension)) {
                try {
                    this.foldingExtensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.foldingExtensions.remove(toRemove);
        }
        this.foldingOutOfSync = false;
    }
}

