/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.intermediate.syncrepl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl.SyncInfoValue;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl.SynchronizationInfoEnum;
import org.apache.directory.api.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.api.util.Strings;

public class SyncInfoValueImpl
extends IntermediateResponseImpl
implements SyncInfoValue {
    private SynchronizationInfoEnum type;
    private byte[] cookie;
    private boolean refreshDone = true;
    private boolean refreshDeletes = false;
    private List<byte[]> syncUUIDs;

    public SyncInfoValueImpl() {
        super("1.3.6.1.4.1.4203.1.9.1.4");
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    @Override
    public boolean isRefreshDone() {
        return this.refreshDone;
    }

    @Override
    public void setRefreshDone(boolean refreshDone) {
        this.refreshDone = refreshDone;
    }

    @Override
    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    @Override
    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    @Override
    public List<byte[]> getSyncUUIDs() {
        if (this.syncUUIDs == null) {
            this.syncUUIDs = new ArrayList<byte[]>();
        }
        return this.syncUUIDs;
    }

    @Override
    public void setSyncUUIDs(List<byte[]> syncUUIDs) {
        this.syncUUIDs = syncUUIDs;
    }

    @Override
    public void addSyncUUID(byte[] syncUUID) {
        if (this.syncUUIDs == null) {
            this.syncUUIDs = new ArrayList<byte[]>();
        }
        this.syncUUIDs.add(syncUUID);
    }

    public int hashCode() {
        int h = super.hashCode();
        h = h * 17 + this.type.getValue();
        h = h * 17 + (this.refreshDone ? 1 : 0);
        h = h * 17 + (this.refreshDeletes ? 1 : 0);
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        if (this.syncUUIDs != null) {
            Object object = this.syncUUIDs.iterator();
            while (object.hasNext()) {
                byte[] bytes = (byte[])object.next();
                if (bytes == null) continue;
                for (byte b : bytes) {
                    h = h * 17 + b;
                }
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncInfoValue)) {
            return false;
        }
        SyncInfoValue otherResponse = (SyncInfoValue)o;
        if (this.syncUUIDs != null) {
            if (otherResponse.getSyncUUIDs() == null) {
                return false;
            }
            for (byte[] syncUuid : this.syncUUIDs) {
                boolean found = false;
                for (byte[] otherSyncUuid : otherResponse.getSyncUUIDs()) {
                    if (!Arrays.equals(syncUuid, otherSyncUuid)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else if (otherResponse.getSyncUUIDs() != null) {
            return false;
        }
        return super.equals(o) && this.refreshDeletes == otherResponse.isRefreshDeletes() && this.refreshDone == otherResponse.isRefreshDone() && Arrays.equals(this.cookie, otherResponse.getCookie());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncInfoValue :\n");
        switch (this.type) {
            case NEW_COOKIE: {
                sb.append("        newCookie : '").append(Strings.utf8ToString((byte[])this.getCookie())).append("'\n");
                break;
            }
            case REFRESH_DELETE: {
                sb.append("        refreshDelete : \n");
                if (this.getCookie() != null) {
                    sb.append("            cookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.isRefreshDone()).append('\n');
                break;
            }
            case REFRESH_PRESENT: {
                sb.append("        refreshPresent : \n");
                if (this.getCookie() != null) {
                    sb.append("            cookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.isRefreshDone()).append('\n');
                break;
            }
            case SYNC_ID_SET: {
                sb.append("        syncIdSet : \n");
                if (this.getCookie() != null) {
                    sb.append("            cookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                }
                sb.append("            refreshDeletes : ").append(this.isRefreshDeletes()).append('\n');
                sb.append("            syncUUIDS : ");
                if (!this.getSyncUUIDs().isEmpty()) {
                    boolean isFirst = true;
                    for (byte[] syncUUID : this.getSyncUUIDs()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(Arrays.toString(syncUUID));
                    }
                    sb.append('\n');
                    break;
                }
                sb.append("empty\n");
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_9300_UNEXPECTED_SYNCINFO, (Object[])new Object[]{this.getType()}));
            }
        }
        return sb.toString();
    }

    @Override
    public SynchronizationInfoEnum getSyncInfoValueType() {
        return this.type;
    }

    @Override
    public void setSyncInfoValueType(SynchronizationInfoEnum type) {
        this.type = type;
    }
}

