/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.StudioLdapException;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResult;
import org.eclipse.core.runtime.Platform;

public interface ILdapLogger {
    default public void logChangetypeAdd(Connection connection, Entry entry, Control[] controls, StudioLdapException ex) {
    }

    default public void logChangetypeDelete(Connection connection, Dn dn, Control[] controls, StudioLdapException ex) {
    }

    default public void logChangetypeModify(Connection connection, Dn dn, Collection<Modification> modifications, Control[] controls, StudioLdapException ex) {
    }

    default public void logChangetypeModDn(Connection connection, Dn oldDn, Dn newDn, boolean deleteOldRdn, Control[] controls, StudioLdapException ex) {
    }

    public void setId(String var1);

    public String getId();

    public void setName(String var1);

    public String getName();

    public void setDescription(String var1);

    public String getDescription();

    default public void logSearchRequest(Connection connection, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Control[] controls, long requestNum, StudioLdapException ex) {
    }

    default public void logSearchResultEntry(Connection connection, StudioSearchResult studioSearchResult, long requestNum, StudioLdapException ex) {
    }

    default public void logSearchResultReference(Connection connection, Referral referral, ReferralsInfo referralsInfo, long requestNum, StudioLdapException ex) {
    }

    default public void logSearchResultDone(Connection connection, long count, long requestNum, StudioLdapException ex) {
    }

    default public Set<String> getMaskedAttributes() {
        String[] splitted;
        HashSet<String> maskedAttributes = new HashSet<String>();
        String maskedAttributeString = Platform.getPreferencesService().getString(ConnectionCoreConstants.PLUGIN_ID, "modificationLogsMaskedAttributes", "", null);
        String[] stringArray = splitted = maskedAttributeString.split(",");
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            maskedAttributes.add(Strings.toLowerCaseAscii((String)s));
            ++n2;
        }
        return maskedAttributes;
    }

    default public void deleteFileWithRetry(File file) {
        int i = 0;
        while (i < 6) {
            if (file != null && file.exists()) {
                if (file.delete()) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }
}

