/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.constants.SaslSecurityStrength;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.ConnectionActionFilterAdapter;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.ConnectionPropertyPageProvider;
import org.apache.directory.studio.connection.core.DetectedConnectionProperties;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.api.DirectoryApiConnectionWrapper;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;

public class Connection
implements ConnectionPropertyPageProvider,
IAdaptable {
    private ConnectionParameter connectionParameter;
    private ConnectionWrapper connectionWrapper;
    private DetectedConnectionProperties detectedConnectionProperties;

    public Connection(ConnectionParameter connectionParameter) {
        this.connectionParameter = connectionParameter;
        this.detectedConnectionProperties = new DetectedConnectionProperties(this);
    }

    public Object clone() {
        ConnectionParameter cp = new ConnectionParameter(this.getName(), this.getHost(), this.getPort(), this.getEncryptionMethod(), this.getAuthMethod(), this.getBindPrincipal(), this.getBindPassword(), this.getSaslRealm(), this.isReadOnly(), this.getConnectionParameter().getExtendedProperties(), this.getTimeoutMillis());
        return new Connection(cp);
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.getDirectoryApiConnectionWrapper();
    }

    private ConnectionWrapper getDirectoryApiConnectionWrapper() {
        if (!(this.connectionWrapper instanceof DirectoryApiConnectionWrapper)) {
            this.connectionWrapper = new DirectoryApiConnectionWrapper(this);
        }
        return this.connectionWrapper;
    }

    public ConnectionParameter getConnectionParameter() {
        return this.connectionParameter;
    }

    public void setConnectionParameter(ConnectionParameter connectionParameter) {
        this.connectionParameter = connectionParameter;
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public DetectedConnectionProperties getDetectedConnectionProperties() {
        return this.detectedConnectionProperties;
    }

    public void setDetectedConnectionProperties(DetectedConnectionProperties detectedConnectionProperties) {
        this.detectedConnectionProperties = detectedConnectionProperties;
    }

    public ConnectionParameter.AuthenticationMethod getAuthMethod() {
        return this.connectionParameter.getAuthMethod();
    }

    public String getBindPassword() {
        return this.connectionParameter.getBindPassword();
    }

    public String getBindPrincipal() {
        return this.connectionParameter.getBindPrincipal();
    }

    public ConnectionParameter.EncryptionMethod getEncryptionMethod() {
        return this.connectionParameter.getEncryptionMethod();
    }

    public String getId() {
        return this.connectionParameter.getId();
    }

    public String getHost() {
        return this.connectionParameter.getHost();
    }

    public String getName() {
        return this.connectionParameter.getName();
    }

    public int getPort() {
        return this.connectionParameter.getPort();
    }

    public String getSaslRealm() {
        return this.connectionParameter.getSaslRealm();
    }

    public SaslQoP getSaslQop() {
        return this.connectionParameter.getSaslQop();
    }

    public SaslSecurityStrength getSaslSecurityStrength() {
        return this.connectionParameter.getSaslSecurityStrength();
    }

    public boolean isSaslMutualAuthentication() {
        return this.connectionParameter.isSaslMutualAuthentication();
    }

    public ConnectionParameter.Krb5CredentialConfiguration getKrb5CredentialConfiguration() {
        return this.connectionParameter.getKrb5CredentialConfiguration();
    }

    public ConnectionParameter.Krb5Configuration getKrb5Configuration() {
        return this.connectionParameter.getKrb5Configuration();
    }

    public String getKrb5ConfigurationFile() {
        return this.connectionParameter.getKrb5ConfigurationFile();
    }

    public String getKrb5Realm() {
        return this.connectionParameter.getKrb5Realm();
    }

    public String getKrb5KdcHost() {
        return this.connectionParameter.getKrb5KdcHost();
    }

    public int getKrb5KdcPort() {
        return this.connectionParameter.getKrb5KdcPort();
    }

    public boolean isReadOnly() {
        return this.connectionParameter.isReadOnly();
    }

    public long getTimeoutMillis() {
        return this.connectionParameter.getTimeoutMillis();
    }

    public void setAuthMethod(ConnectionParameter.AuthenticationMethod authMethod) {
        this.connectionParameter.setAuthMethod(authMethod);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setBindPassword(String bindPassword) {
        this.connectionParameter.setBindPassword(bindPassword);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setBindPrincipal(String bindPrincipal) {
        this.connectionParameter.setBindPrincipal(bindPrincipal);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setEncryptionMethod(ConnectionParameter.EncryptionMethod encryptionMethod) {
        this.connectionParameter.setEncryptionMethod(encryptionMethod);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setHost(String host) {
        this.connectionParameter.setHost(host);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setName(String name) {
        this.connectionParameter.setName(name);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setPort(int port) {
        this.connectionParameter.setPort(port);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setSaslRealm(String realm) {
        this.connectionParameter.setSaslRealm(realm);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.connectionParameter.setReadOnly(isReadOnly);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.connectionParameter.setTimeoutMillis(timeoutMillis);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Connection.class) {
            return this;
        }
        if (adapter.isAssignableFrom(IActionFilter.class)) {
            return ConnectionActionFilterAdapter.getInstance();
        }
        return null;
    }

    public LdapUrl getUrl() {
        LdapUrl url = new LdapUrl();
        url.setHost(this.getHost());
        url.setPort(this.getPort());
        return url;
    }

    public static enum AliasDereferencingMethod {
        NEVER(0),
        ALWAYS(1),
        FINDING(2),
        SEARCH(3);

        private final int ordinal;

        private AliasDereferencingMethod(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static AliasDereferencingMethod getByOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return NEVER;
                }
                case 1: {
                    return ALWAYS;
                }
                case 2: {
                    return FINDING;
                }
                case 3: {
                    return SEARCH;
                }
            }
            return null;
        }
    }

    public static enum ReferralHandlingMethod {
        IGNORE(0),
        FOLLOW(1),
        FOLLOW_MANUALLY(3);

        private final int ordinal;

        private ReferralHandlingMethod(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static ReferralHandlingMethod getByOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return IGNORE;
                }
                case 1: {
                    return FOLLOW;
                }
                case 2: {
                    return FOLLOW_MANUALLY;
                }
                case 3: {
                    return FOLLOW_MANUALLY;
                }
            }
            return null;
        }
    }
}

