/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionType;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionWrapper;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionsMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PartitionsPage
extends ServerConfigurationEditorPage {
    public static final String ID = PartitionsPage.class.getName();
    private static final String TITLE = Messages.getString("PartitionsPage.Partitions");
    private PartitionsMasterDetailsBlock masterDetailsBlock;
    public static LabelProvider PARTITIONS_LABEL_PROVIDER = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof PartitionBean) {
                PartitionBean partition = (PartitionBean)element;
                return NLS.bind((String)"{0} ({1}) [{2}]", (Object[])new Object[]{partition.getPartitionId(), partition.getPartitionSuffix(), this.getPartitionType(partition)});
            }
            if (element instanceof PartitionWrapper) {
                return this.getText(((PartitionWrapper)element).getPartition());
            }
            return super.getText(element);
        }

        private String getPartitionType(PartitionBean partition) {
            PartitionType type = PartitionType.fromPartition(partition);
            if (type != null) {
                return type.toString();
            }
            return "Unknown";
        }

        public Image getImage(Object element) {
            if (element instanceof PartitionBean) {
                PartitionBean partition = (PartitionBean)element;
                if (PartitionsPage.isSystemPartition(partition)) {
                    return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/partition_system.gif");
                }
                return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/partition.gif");
            }
            if (element instanceof PartitionWrapper) {
                return this.getImage(((PartitionWrapper)element).getPartition());
            }
            return super.getImage(element);
        }
    };
    public static ViewerComparator PARTITIONS_COMPARATOR = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PartitionBean && e2 instanceof PartitionBean) {
                PartitionBean partition1 = (PartitionBean)e1;
                PartitionBean partition2 = (PartitionBean)e2;
                String partition1Id = partition1.getPartitionId();
                String partition2Id = partition2.getPartitionId();
                if (partition1Id != null && partition2Id != null) {
                    return partition1Id.compareTo(partition2Id);
                }
            }
            if (e1 instanceof PartitionWrapper && e2 instanceof PartitionWrapper) {
                return this.compare(viewer, ((PartitionWrapper)e1).getPartition(), ((PartitionWrapper)e2).getPartition());
            }
            return super.compare(viewer, e1, e2);
        }
    };

    public PartitionsPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        this.masterDetailsBlock = new PartitionsMasterDetailsBlock(this);
        this.masterDetailsBlock.createContent(this.getManagedForm());
    }

    @Override
    protected void refreshUI() {
        if (this.isInitialized()) {
            this.masterDetailsBlock.refreshUI();
        }
    }

    public static boolean isSystemPartition(PartitionBean partition) {
        if (partition != null) {
            return "system".equalsIgnoreCase(partition.getPartitionId());
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.masterDetailsBlock != null) {
            this.masterDetailsBlock.doSave(monitor);
        }
    }
}

