/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)LogUtil.class.getName());

    private LogUtil() {
    }

    public static void logIt(String msg) {
        if (LOG.isDebugEnabled() || LOG.isInfoEnabled() || LOG.isWarnEnabled() || LOG.isErrorEnabled()) {
            if (StringUtils.isNotEmpty((CharSequence)LogUtil.getContext())) {
                msg = LogUtil.getContext() + " " + (String)msg;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((String)msg);
            } else if (LOG.isInfoEnabled()) {
                LOG.info((String)msg);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((String)msg);
            } else if (LOG.isErrorEnabled()) {
                LOG.error((String)msg);
            }
        }
    }

    public static String getContext() {
        String contextId = null;
        String tenant = System.getProperty("tenant");
        if (StringUtils.isNotEmpty((CharSequence)tenant) && !tenant.equals("${tenant}")) {
            contextId = tenant;
        }
        return contextId;
    }
}

