/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.injection;

import java.lang.annotation.Annotation;
import javax.faces.FacesWrapper;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;

abstract class AbstractContextualReferenceWrapper<T>
implements PartialStateHolder,
FacesWrapper<T> {
    private T wrapped;
    private transient Boolean fullStateSavingFallbackEnabled;

    protected AbstractContextualReferenceWrapper() {
    }

    protected AbstractContextualReferenceWrapper(T wrapped, boolean fullStateSavingFallbackEnabled) {
        this.wrapped = wrapped;
        this.fullStateSavingFallbackEnabled = fullStateSavingFallbackEnabled;
    }

    public void markInitialState() {
        if (this.wrapped instanceof PartialStateHolder) {
            ((PartialStateHolder)this.wrapped).markInitialState();
        }
    }

    public void clearInitialState() {
        if (this.wrapped instanceof PartialStateHolder) {
            ((PartialStateHolder)this.wrapped).clearInitialState();
        }
    }

    public boolean initialStateMarked() {
        return this.wrapped instanceof PartialStateHolder && ((PartialStateHolder)this.wrapped).initialStateMarked();
    }

    public Object saveState(FacesContext context) {
        if (this.fullStateSavingFallbackEnabled == null) {
            this.fullStateSavingFallbackEnabled = ((JsfModuleConfig)BeanProvider.getContextualReference(JsfModuleConfig.class, (Annotation[])new Annotation[0])).isFullStateSavingFallbackEnabled();
        }
        if (this.wrapped instanceof StateHolder) {
            Object[] result = new Object[2];
            if (this.fullStateSavingFallbackEnabled.booleanValue()) {
                result[0] = this.getWrapped().getClass().getName();
            }
            result[1] = ((StateHolder)this.wrapped).saveState(context);
            return result;
        }
        if (this.fullStateSavingFallbackEnabled.booleanValue()) {
            Object[] result = new Object[]{this.getWrapped().getClass().getName()};
            return result;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] wrappedState = (Object[])state;
        if (this.wrapped == null) {
            Class wrappedClass = ClassUtils.tryToLoadClassForName((String)((String)wrappedState[0]));
            T resolvedInstance = this.resolveInstanceForClass(context, wrappedClass);
            if (resolvedInstance instanceof AbstractContextualReferenceWrapper) {
                resolvedInstance = ((AbstractContextualReferenceWrapper)resolvedInstance).getWrapped();
            }
            this.wrapped = resolvedInstance;
        }
        if (this.wrapped == null) {
            this.wrapped = ClassUtils.tryToInstantiateClassForName((String)((String)wrappedState[0]));
            BeanProvider.injectFields(this.wrapped);
        }
        if (this.wrapped instanceof StateHolder) {
            ((StateHolder)this.wrapped).restoreState(context, wrappedState[1]);
        }
    }

    public boolean isTransient() {
        return this.wrapped instanceof StateHolder && ((StateHolder)this.wrapped).isTransient();
    }

    public void setTransient(boolean newTransientValue) {
        if (this.wrapped instanceof StateHolder) {
            ((StateHolder)this.wrapped).setTransient(newTransientValue);
        }
    }

    public T getWrapped() {
        return this.wrapped;
    }

    protected abstract T resolveInstanceForClass(FacesContext var1, Class<?> var2);
}

