/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.transaction;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.testcontrol.spi.junit.TestStatementDecoratorFactory;
import org.junit.After;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class TransactionStatementDecoratorFactory
implements TestStatementDecoratorFactory {
    private static final Logger LOG = Logger.getLogger(TransactionStatementDecoratorFactory.class.getName());

    public Statement createBeforeStatement(Statement originalStatement, TestClass testClass, Object target) {
        return originalStatement;
    }

    public Statement createAfterStatement(Statement originalStatement, TestClass testClass, Object target) {
        List afters = testClass.getAnnotatedMethods(After.class);
        return new TransactionAwareRunAfters(originalStatement, afters, target);
    }

    public int getOrdinal() {
        return 1000;
    }

    static {
        LOG.setLevel(Level.INFO);
    }

    private class TransactionAwareRunAfters
    extends Statement {
        private final Statement wrapped;
        private final List<FrameworkMethod> afters;
        private final Object target;

        public TransactionAwareRunAfters(Statement wrapped, List<FrameworkMethod> afters, Object target) {
            this.wrapped = wrapped;
            this.afters = afters;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            ArrayList<Throwable> result = new ArrayList<Throwable>();
            try {
                this.wrapped.evaluate();
            }
            catch (Throwable e) {
                result.add(this.performConsistencyCheck(e));
            }
            finally {
                Throwable t = this.performConsistencyCheck(null);
                if (t != null) {
                    result.add(t);
                }
                for (FrameworkMethod each : this.afters) {
                    try {
                        each.invokeExplosively(this.target, new Object[0]);
                    }
                    catch (Throwable e) {
                        result.add(e);
                    }
                }
            }
            if (!result.isEmpty()) {
                MultipleFailureException.assertEmpty(result);
            }
        }

        private Throwable performConsistencyCheck(Throwable t) {
            Throwable result = t;
            if (t instanceof InvocationTargetException) {
                result = t.getCause();
            }
            List entityManagerList = BeanProvider.getContextualReferences(EntityManager.class, (boolean)true, (boolean)false);
            for (Field field : this.target.getClass().getDeclaredFields()) {
                if (!EntityManager.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    entityManagerList.add((EntityManager)field.get(this.target));
                }
                catch (Exception e) {
                    throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
                }
            }
            for (EntityManager entityManager : entityManagerList) {
                if (!entityManager.getTransaction().isActive()) continue;
                if (t instanceof AssertionFailedError) {
                    LOG.severe("assert failed within a transaction");
                }
                LOG.severe("start manual rollback");
                entityManager.getTransaction().rollback();
                if (result != null) continue;
                result = new IllegalStateException("open transaction found");
            }
            return result;
        }
    }
}

