/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.throttling;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.util.ExceptionUtils;

class Invoker {
    private final int weight;
    private final Semaphore semaphore;
    private final long timeout;

    Invoker(Semaphore semaphore, int weight, long timeout) {
        this.semaphore = semaphore;
        this.weight = weight;
        this.timeout = timeout;
    }

    public Object invoke(InvocationContext context) throws Exception {
        block9: {
            if (this.timeout > 0L) {
                try {
                    if (!this.semaphore.tryAcquire(this.weight, this.timeout, TimeUnit.MILLISECONDS)) {
                        throw new IllegalStateException("Can't acquire " + this.weight + " permits for " + context.getMethod() + " in " + this.timeout + "ms");
                    }
                    break block9;
                }
                catch (InterruptedException e) {
                    return Invoker.onInterruption(e);
                }
            }
            try {
                this.semaphore.acquire(this.weight);
            }
            catch (InterruptedException e) {
                return Invoker.onInterruption(e);
            }
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            this.semaphore.release(this.weight);
        }
    }

    private static Semaphore onInterruption(InterruptedException e) {
        Thread.interrupted();
        throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
    }
}

