/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.util.ExceptionMapper;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.TorqueConnectionImpl;
import org.apache.torque.util.TransactionManager;

public class TransactionManagerImpl
implements TransactionManager {
    private static final Logger log = LogManager.getLogger(TransactionManagerImpl.class);

    @Override
    public TorqueConnection begin() throws TorqueException {
        return this.begin(Torque.getDefaultDB());
    }

    @Override
    public TorqueConnection begin(String dbName) throws TorqueException {
        TorqueConnectionImpl con = new TorqueConnectionImpl(Torque.getConnection(dbName));
        return con;
    }

    @Override
    public void commit(Connection con) throws TorqueException {
        if (con == null) {
            throw new NullPointerException("Connection object was null. This could be due to a misconfiguration of the DataSourceFactory. Check the logs and Torque.properties to better determine the cause.");
        }
        try {
            if (con.getMetaData().supportsTransactions()) {
                if (!con.getAutoCommit()) {
                    con.commit();
                }
                if (con instanceof TorqueConnection) {
                    ((TorqueConnection)con).setCommitted(true);
                }
            }
        }
        catch (SQLException e) {
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            Torque.closeConnection(con);
        }
    }

    @Override
    public void rollback(Connection con) throws TorqueException {
        if (con == null) {
            throw new TorqueException("Connection object was null. This could be due to a misconfiguration of the DataSourceFactory. Check the logs and Torque.properties to better determine the cause.");
        }
        try {
            if (con.isClosed()) {
                log.warn("Connection is already closed. Reason could be, if rollback was already called before.");
            } else if (con.getMetaData().supportsTransactions() && !con.getAutoCommit()) {
                con.rollback();
                if (con instanceof TorqueConnection) {
                    ((TorqueConnection)con).setRolledBack(true);
                }
            }
        }
        catch (SQLException e) {
            log.error("An attempt was made to rollback a transaction but the database did not allow the operation to be rolled back.", (Throwable)e);
            throw ExceptionMapper.getInstance().toTorqueException(e);
        }
        finally {
            Torque.closeConnection(con);
        }
    }

    @Override
    public void safeRollback(Connection con) {
        if (con == null) {
            log.debug("called safeRollback with null argument");
        } else {
            try {
                this.rollback(con);
            }
            catch (TorqueException e) {
                log.warn("An error occured during rollback.", (Throwable)e);
            }
        }
    }
}

