/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;

public abstract class ContentSource {
    public static ContentSource create(ObjectReader reader) {
        return new ObjectReaderSource(reader);
    }

    public static ContentSource create(WorkingTreeIterator iterator) {
        if (iterator instanceof FileTreeIterator) {
            FileTreeIterator i = (FileTreeIterator)iterator;
            return new FileSource(i.getDirectory());
        }
        return new WorkingTreeSource(iterator);
    }

    public abstract long size(String var1, ObjectId var2) throws IOException;

    public abstract ObjectLoader open(String var1, ObjectId var2) throws IOException;

    public static final class Pair {
        private final ContentSource oldSource;
        private final ContentSource newSource;

        public Pair(ContentSource oldSource, ContentSource newSource) {
            this.oldSource = oldSource;
            this.newSource = newSource;
        }

        public long size(DiffEntry.Side side, DiffEntry ent) throws IOException {
            switch (side) {
                case OLD: {
                    return this.oldSource.size(ent.oldPath, ent.oldId.toObjectId());
                }
                case NEW: {
                    return this.newSource.size(ent.newPath, ent.newId.toObjectId());
                }
            }
            throw new IllegalArgumentException();
        }

        public ObjectLoader open(DiffEntry.Side side, DiffEntry ent) throws IOException {
            switch (side) {
                case OLD: {
                    return this.oldSource.open(ent.oldPath, ent.oldId.toObjectId());
                }
                case NEW: {
                    return this.newSource.open(ent.newPath, ent.newId.toObjectId());
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class FileSource
    extends ContentSource {
        private final File root;

        FileSource(File root) {
            this.root = root;
        }

        public long size(String path, ObjectId id) throws IOException {
            return new File(this.root, path).length();
        }

        public ObjectLoader open(String path, ObjectId id) throws IOException {
            final File p = new File(this.root, path);
            if (!p.isFile()) {
                throw new FileNotFoundException(path);
            }
            return new ObjectLoader(){

                public long getSize() {
                    return p.length();
                }

                public int getType() {
                    return 3;
                }

                public ObjectStream openStream() throws MissingObjectException, IOException {
                    FileInputStream in = new FileInputStream(p);
                    long sz = in.getChannel().size();
                    int type = this.getType();
                    BufferedInputStream b = new BufferedInputStream(in);
                    return new ObjectStream.Filter(type, sz, b);
                }

                public boolean isLarge() {
                    return true;
                }

                public byte[] getCachedBytes() throws LargeObjectException {
                    throw new LargeObjectException();
                }
            };
        }
    }

    private static class WorkingTreeSource
    extends ContentSource {
        private final TreeWalk tw = new TreeWalk((ObjectReader)null);
        private final WorkingTreeIterator iterator;
        private String current;
        private WorkingTreeIterator ptr;

        WorkingTreeSource(WorkingTreeIterator iterator) {
            this.iterator = iterator;
        }

        public long size(String path, ObjectId id) throws IOException {
            this.seek(path);
            return this.ptr.getEntryLength();
        }

        public ObjectLoader open(String path, ObjectId id) throws IOException {
            this.seek(path);
            return new ObjectLoader(){

                public long getSize() {
                    return WorkingTreeSource.this.ptr.getEntryLength();
                }

                public int getType() {
                    return WorkingTreeSource.this.ptr.getEntryFileMode().getObjectType();
                }

                public ObjectStream openStream() throws MissingObjectException, IOException {
                    long contentLength = WorkingTreeSource.this.ptr.getEntryContentLength();
                    InputStream in = WorkingTreeSource.this.ptr.openEntryStream();
                    in = new BufferedInputStream(in);
                    return new ObjectStream.Filter(this.getType(), contentLength, in);
                }

                public boolean isLarge() {
                    return true;
                }

                public byte[] getCachedBytes() throws LargeObjectException {
                    throw new LargeObjectException();
                }
            };
        }

        private void seek(String path) throws IOException {
            if (!path.equals(this.current)) {
                this.iterator.reset();
                this.tw.reset();
                this.tw.addTree(this.iterator);
                this.tw.setFilter(PathFilter.create(path));
                this.current = path;
                if (!this.tw.next()) {
                    throw new FileNotFoundException(path);
                }
                this.ptr = this.tw.getTree(0, WorkingTreeIterator.class);
                if (this.ptr == null) {
                    throw new FileNotFoundException(path);
                }
            }
        }
    }

    private static class ObjectReaderSource
    extends ContentSource {
        private final ObjectReader reader;

        ObjectReaderSource(ObjectReader reader) {
            this.reader = reader;
        }

        public long size(String path, ObjectId id) throws IOException {
            return this.reader.getObjectSize(id, 3);
        }

        public ObjectLoader open(String path, ObjectId id) throws IOException {
            return this.reader.open(id, 3);
        }
    }
}

