/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet.java;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.outlet.OutletImpl;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.QualifiedName;

public class ModifySourcenameOutlet
extends OutletImpl {
    private String prefix = "";
    private String suffix = "";
    private String discardFrom = null;
    private String discardTo = null;
    private static Logger logger = Logger.getLogger(ModifySourcenameOutlet.class);

    public ModifySourcenameOutlet(QualifiedName qualifiedName) {
        super(qualifiedName);
    }

    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        String result;
        int position;
        File sourceFile = controllerState.getSourceFile();
        if (sourceFile == null) {
            logger.warn((Object)"execute(): sourceFile is null, returning the empty String");
            return new OutletResult("");
        }
        String sourceName = sourceFile.getName();
        int startFrom = 0;
        int endAt = sourceName.length();
        if (!StringUtils.isEmpty((String)this.discardTo) && (position = sourceName.lastIndexOf(this.discardTo)) != -1) {
            startFrom = position + this.discardTo.length();
        }
        if (!StringUtils.isEmpty((String)this.discardFrom) && (position = sourceName.indexOf(this.discardFrom)) != -1) {
            endAt = position;
        }
        if (startFrom <= endAt) {
            result = sourceName.substring(startFrom, endAt);
        } else {
            logger.debug((Object)"execute(): startFrom is later than endAt, returning the empty String");
            result = "";
        }
        result = this.prefix + result + this.suffix;
        return new OutletResult(result);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (suffix == null) {
            throw new NullPointerException("suffix is null");
        }
        this.suffix = suffix;
    }

    public String getDiscardFrom() {
        return this.discardFrom;
    }

    public void setDiscardFrom(String discardFrom) {
        this.discardFrom = discardFrom;
    }

    public String getDiscardTo() {
        return this.discardTo;
    }

    public void setDiscardTo(String discardTo) {
        this.discardTo = discardTo;
    }
}

