/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.torque.templates.platform.PlatformDefaultImpl;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformHsqldbImpl
extends PlatformDefaultImpl {
    private static final String DATE_FORMAT = "''yyyy-MM-dd''";
    private static final String TIME_FORMAT = "''HH:mm:ss''";

    public PlatformHsqldbImpl() {
        this.initialize();
    }

    private void initialize() {
        this.setSchemaTypeToSqlTypeMapping(SchemaType.CHAR, new SqlType("VARCHAR", "1"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANCHAR, new SqlType("VARCHAR", "1"));
    }

    public String getAutoIncrement() {
        return "GENERATED BY DEFAULT AS IDENTITY (START WITH 1)";
    }

    public boolean createNotNullBeforeAutoincrement() {
        return false;
    }

    protected boolean escapeBackslashes() {
        return false;
    }

    public String getDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public String getTimeString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    public boolean usesStandaloneSchema() {
        return true;
    }
}

