/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class UnionInputStream
extends InputStream {
    private static final InputStream EOF = new InputStream(){

        public int read() throws IOException {
            return -1;
        }
    };
    private final LinkedList<InputStream> streams = new LinkedList();

    public UnionInputStream() {
    }

    public UnionInputStream(InputStream ... inputStreams) {
        for (InputStream i : inputStreams) {
            this.add(i);
        }
    }

    private InputStream head() {
        return this.streams.isEmpty() ? EOF : this.streams.getFirst();
    }

    private void pop() throws IOException {
        if (!this.streams.isEmpty()) {
            this.streams.removeFirst().close();
        }
    }

    public void add(InputStream in) {
        this.streams.add(in);
    }

    public boolean isEmpty() {
        return this.streams.isEmpty();
    }

    public int read() throws IOException {
        InputStream in;
        int r;
        while (0 > (r = (in = this.head()).read())) {
            if (in == EOF) {
                return -1;
            }
            this.pop();
        }
        return r;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        InputStream in;
        int n;
        while (0 >= (n = (in = this.head()).read(b, off, len))) {
            if (in == EOF) {
                return -1;
            }
            this.pop();
        }
        return n;
    }

    public int available() throws IOException {
        return this.head().available();
    }

    public long skip(long len) throws IOException {
        long cnt = 0L;
        while (0L < len) {
            InputStream in = this.head();
            long n = in.skip(len);
            if (0L < n) {
                cnt += n;
                len -= n;
                continue;
            }
            if (in == EOF) {
                return cnt;
            }
            int r = in.read();
            if (r < 0) {
                this.pop();
                if (0L >= cnt) continue;
                break;
            }
            ++cnt;
            --len;
        }
        return cnt;
    }

    public void close() throws IOException {
        IOException err = null;
        Iterator i = this.streams.iterator();
        while (i.hasNext()) {
            try {
                ((InputStream)i.next()).close();
            }
            catch (IOException closeError) {
                err = closeError;
            }
            i.remove();
        }
        if (err != null) {
            throw err;
        }
    }
}

