/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class LogDeviceTest {
    private static final String TEST_DATABASE_NAME = "wombat";
    private static final String TEST_DATABASE_NAME1 = "wombat1";
    private static final String TEST_TABLE_NAME = "emp";
    private static final String LOG_PATH = "extinout/logDeviceTest_c1";
    private static final String LOG_PATH1 = "extinout/logDeviceTest_c2";

    public static void main(String[] stringArray) throws Throwable {
        LogDeviceTest logDeviceTest = new LogDeviceTest();
        ij.getPropertyArg((String[])stringArray);
        try {
            logDeviceTest.runTest();
        }
        catch (SQLException sQLException) {
            LogDeviceTest.dumpSQLException(sQLException);
        }
    }

    private String getFullPath(String string) throws IOException {
        File file = new File(string);
        return file.getCanonicalPath();
    }

    private boolean createDir(String string) {
        File file = new File(string);
        return file.mkdirs();
    }

    private void runTest() throws Exception {
        this.logMessage("Begin Log Device Test");
        String string = "create=true;logDevice=" + this.getFullPath(LOG_PATH);
        Connection connection = TestUtil.getConnection(TEST_DATABASE_NAME, string);
        connection.setAutoCommit(false);
        this.createTable(connection, TEST_TABLE_NAME);
        connection.commit();
        this.insert(connection, TEST_TABLE_NAME, 100);
        connection.commit();
        this.insert(connection, TEST_TABLE_NAME, 100);
        connection.rollback();
        this.shutdown(TEST_DATABASE_NAME);
        try {
            connection = TestUtil.getConnection(TEST_DATABASE_NAME1, string);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException.getNextException();
            if (sQLException2 != null) {
                if (sQLException2.getSQLState().equals("XSLAT")) {
                    System.out.println("Failed with Expected error:" + sQLException2.getSQLState());
                } else {
                    LogDeviceTest.dumpSQLException(sQLException);
                }
            }
            LogDeviceTest.dumpSQLException(sQLException);
        }
        this.createDir(this.getFullPath(LOG_PATH1) + File.separator + "log");
        string = "create=true;logDevice=" + this.getFullPath(LOG_PATH1);
        connection = TestUtil.getConnection(TEST_DATABASE_NAME1, string);
        connection.setAutoCommit(false);
        this.createTable(connection, TEST_TABLE_NAME);
        connection.commit();
        this.insert(connection, TEST_TABLE_NAME, 100);
        this.shutdown(TEST_DATABASE_NAME1);
        connection = TestUtil.getConnection(TEST_DATABASE_NAME1, null);
        this.logMessage("End log device Test");
    }

    private void shutdown(String string) {
        try {
            TestUtil.getConnection(string, "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            }
            LogDeviceTest.dumpSQLException(sQLException);
        }
    }

    private void logMessage(String string) {
        System.out.println(string);
    }

    private static void dumpSQLException(SQLException sQLException) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        sQLException.printStackTrace(System.out);
    }

    private void insert(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + string + " VALUES(?,?,?)");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "skywalker" + i);
            preparedStatement.setFloat(3, i * 2000);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    private void createTable(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE " + string + "(id INT,name CHAR(200),salary float)");
        statement.executeUpdate("create index " + string + "_id_idx on " + string + "(id)");
        statement.close();
    }
}

