/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CallableTest
extends BaseJDBCTestCase {
    private static final String[] ROUTINES = new String[]{"CREATE PROCEDURE TWO_IN_ONE_OUT_PROC (IN P1 INT, IN P2 INT, OUT P3 INT) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".twoInOneOutProc'", "CREATE FUNCTION ONE_IN_ONE_OUT_FUNC (P1 INT) RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".oneInOneOutFunc'", "CREATE FUNCTION NO_IN_ONE_OUT_FUNC() RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".noInOneOutFunc'", "CREATE PROCEDURE SYSTEM_OUT_PRINTLN_PROC() NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".systemOutPrintlnProc'", "CREATE PROCEDURE UPDATE_LONGVARBINARY_PROC (P1 VARCHAR(10000) FOR BIT DATA) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".updateLongVarbinaryProc'", "CREATE PROCEDURE NUMERIC_BOUNDARIES_PROC (OUT P1 DECIMAL(31,15), OUT P2 DECIMAL(31,15), OUT P3 DECIMAL(31,15)) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".numericBoundariesProc'", "CREATE PROCEDURE NUMERIC_TYPES_IN_AND_OUT_PROC (IN P1 SMALLINT, IN P2 INT, IN P3 BIGINT, IN P4 REAL, IN P5 DOUBLE, IN P6 DECIMAL(6,3), OUT O1 SMALLINT, OUT O2 INT, OUT O3 BIGINT, OUT O4 REAL, OUT O5 DOUBLE, OUT O6 DECIMAL(6,3) ) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".manyTypesInAndOutProc'", "CREATE PROCEDURE NON_NUMERIC_TYPES_IN_AND_OUT_PROC (IN P1 DATE, IN P2 TIME, IN P3 TIMESTAMP, IN P4 VARCHAR(20) FOR BIT DATA, OUT O1 DATE, OUT O2 TIME, OUT O3 TIMESTAMP, OUT O4 VARCHAR(20) FOR BIT DATA) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".manyTypesInAndOutProc'", "CREATE PROCEDURE MANY_TYPES_INOUT_PROC (IN P1 SMALLINT, INOUT P2 SMALLINT, IN P3 INT, INOUT P4 INT, IN P5 BIGINT, INOUT P6 BIGINT, IN P7 REAL, INOUT P8 REAL, IN P9 DOUBLE, INOUT P10 DOUBLE, IN P11 TIME, INOUT P12 TIME) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".manyTypesInoutProc'", "CREATE PROCEDURE BIGDECIMAL_IN_AND_OUT_PROC (IN P1 DECIMAL(14,4), OUT P2 DECIMAL(14,4), IN P3 DECIMAL(14,4), OUT P4 DECIMAL(14,4), OUT P5 DECIMAL(14,4), OUT P6 DECIMAL(14,4), OUT P7 DECIMAL(14,4), OUT P8 DECIMAL(14,4), OUT P9 DECIMAL(14,4)) EXTERNAL NAME '" + CallableTest.class.getName() + ".bigDecimalInAndOutProc' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA", "CREATE PROCEDURE BATCH_UPDATE_PROC (P1 INT, P2 INT) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CallableTest.class.getName() + ".batchUpdateProc'"};
    private static final String[][] TABLES = new String[][]{{"LONGVARBINARY_TABLE", "CREATE TABLE LONGVARBINARY_TABLE (lvbc Long varchar for bit data)"}, {"NUMERIC_BOUNDARIES_TABLE", "CREATE TABLE NUMERIC_BOUNDARIES_TABLE (maxcol NUMERIC(31,15), mincol NUMERIC(15,15), nulcol NUMERIC)"}, {"BATCH_TABLE", "CREATE TABLE BATCH_TABLE (id int, tag varchar(32), idval int constraint idval_ck check (idval >= 0))"}};

    public CallableTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CallableTest");
        baseTestSuite.addTest(CallableTest.baseSuite("CallableTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(CallableTest.baseSuite("CallableTest:client")));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionCPDecorator(CallableTest.baseSuite("CallableTest:logical"))));
        baseTestSuite.addTest(TestConfiguration.connectionXADecorator(CallableTest.baseSuite("CallableTest:brokered")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(CallableTest.class);
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest((Test)new CallableTest("xtestUpdateLongBinaryProc"));
            baseTestSuite.addTest((Test)new CallableTest("xtestBatchUpdate"));
            baseTestSuite.addTest((Test)new CallableTest("xtestBatchUpdateError"));
            baseTestSuite.addTest((Test)new CallableTest("xtestBigDecimalInAndOutProc"));
            baseTestSuite.addTest((Test)new CallableTest("xtestNumericTypesInAndOutProc"));
            baseTestSuite.addTest((Test)new CallableTest("xtestNumericBoundariesProc"));
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                for (n = 0; n < ROUTINES.length; ++n) {
                    statement.execute(ROUTINES[n]);
                }
                for (n = 0; n < TABLES.length; ++n) {
                    statement.execute(TABLES[n][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            statement.execute("DELETE FROM " + TABLES[i][0]);
        }
        statement.close();
        connection.commit();
    }

    public void testTwoInOneOutProc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        callableStatement.setInt(1, 6);
        callableStatement.setInt(2, 9);
        callableStatement.registerOutParameter(3, 4);
        callableStatement.execute();
        CallableTest.assertEquals((String)"Sum of 6 and 9", (int)15, (int)callableStatement.getInt(3));
    }

    public void testOneInOneOutFunc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = call ONE_IN_ONE_OUT_FUNC (?)");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.setInt(2, 6);
        callableStatement.execute();
        CallableTest.assertEquals((String)"Square of 6 then plus 6", (int)42, (int)callableStatement.getInt(1));
    }

    public void testNoInOneOutFunc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = call NO_IN_ONE_OUT_FUNC()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.execute();
        CallableTest.assertEquals((String)"NO_IN_ONE_OUT_FUNC output value", (int)55, (int)callableStatement.getInt(1));
    }

    public void testIsolationLevelChangeAfterFunctionCall() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = CALL NO_IN_ONE_OUT_FUNC()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.execute();
        CallableTest.assertEquals((int)55, (int)callableStatement.getInt(1));
        this.getConnection().setTransactionIsolation(8);
    }

    public void norun_testSystemOutPrintlnProc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call SYSTEM_OUT_PRINTLN_PROC()");
        callableStatement.execute();
        callableStatement.close();
    }

    public void xtestNumericTypesInAndOutProc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        callableStatement.setShort(1, (short)3);
        callableStatement.setInt(2, 4);
        callableStatement.setLong(3, 5L);
        callableStatement.setFloat(4, 6.0f);
        callableStatement.setDouble(5, 7.0);
        callableStatement.setBigDecimal(6, new BigDecimal("88.88"));
        callableStatement.registerOutParameter(7, 5);
        callableStatement.registerOutParameter(8, 4);
        callableStatement.registerOutParameter(9, -5);
        callableStatement.registerOutParameter(10, 7);
        callableStatement.registerOutParameter(11, 8);
        callableStatement.registerOutParameter(12, 3);
        callableStatement.execute();
        CallableTest.assertEquals((String)"OUT short", (short)3, (short)callableStatement.getShort(7));
        CallableTest.assertEquals((String)"OUT int", (int)4, (int)callableStatement.getInt(8));
        CallableTest.assertEquals((String)"OUT long", (long)5L, (long)callableStatement.getLong(9));
        CallableTest.assertEquals((String)"OUT float", (double)6.0, (double)callableStatement.getFloat(10), (double)1.0E-4);
        CallableTest.assertEquals((String)"OUT double", (double)7.0, (double)callableStatement.getDouble(11), (double)1.0E-4);
        this.assertDecimalSameValue("OUT decimal", "88.88", callableStatement.getBigDecimal(12));
        callableStatement.setObject(3, (Object)new BigDecimal("10"));
        callableStatement.execute();
        CallableTest.assertEquals((String)"OUT long", (long)10L, (long)callableStatement.getLong(9));
        callableStatement.setObject(3, (Object)new BigInteger("11"));
        callableStatement.execute();
        CallableTest.assertEquals((String)"OUT long", (long)11L, (long)callableStatement.getLong(9));
    }

    public void testNonNumericTypesInAndOutProc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        callableStatement.setDate(1, Date.valueOf("2002-05-12"));
        callableStatement.setTime(2, Time.valueOf("10:05:02"));
        callableStatement.setTimestamp(3, Timestamp.valueOf("2002-05-12 10:05:02.000000000"));
        byte[] byArray = new byte[]{1, 2};
        callableStatement.setBytes(4, byArray);
        callableStatement.registerOutParameter(5, 91);
        callableStatement.registerOutParameter(6, 92);
        callableStatement.registerOutParameter(7, 93);
        callableStatement.registerOutParameter(8, -3);
        callableStatement.execute();
        CallableTest.assertEquals((String)"OUT date", (Object)Date.valueOf("2002-05-12"), (Object)callableStatement.getDate(5));
        CallableTest.assertEquals("OUT time", Time.valueOf("10:05:02"), callableStatement.getTime(6));
        CallableTest.assertEquals((String)"OUT timestamp", (Object)Timestamp.valueOf("2002-05-12 10:05:02.000000000"), (Object)callableStatement.getTimestamp(7));
        CallableTest.assertTrue((boolean)Arrays.equals(byArray, callableStatement.getBytes(8)));
    }

    public void testTimeAndDateWithCalendar() throws SQLException {
        int n;
        Calendar[] calendarArray = new Calendar[]{Calendar.getInstance(), Calendar.getInstance(TimeZone.getTimeZone("GMT")), Calendar.getInstance(TimeZone.getTimeZone("Europe/Oslo")), Calendar.getInstance(TimeZone.getTimeZone("Asia/Hong_Kong"))};
        Calendar[] calendarArray2 = (Calendar[])calendarArray.clone();
        for (n = 0; n < calendarArray2.length; ++n) {
            calendarArray2[n] = (Calendar)calendarArray2[n].clone();
        }
        for (n = 0; n < calendarArray.length; ++n) {
            for (int i = 0; i < calendarArray2.length; ++i) {
                this.testTimeAndDateWithCalendar(calendarArray[n], calendarArray2[i]);
            }
        }
    }

    private void testTimeAndDateWithCalendar(Calendar calendar, Calendar calendar2) throws SQLException {
        CallableTest.println("Running " + this.getName() + "() with " + calendar.getTimeZone().getDisplayName() + " and " + calendar2.getTimeZone().getDisplayName());
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        Date date = Date.valueOf("2010-04-14");
        Time time = Time.valueOf("12:23:24");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        timestamp.setNanos(123456789);
        callableStatement.setDate(1, date, calendar);
        callableStatement.setTime(2, time, calendar);
        callableStatement.setTimestamp(3, timestamp, calendar);
        callableStatement.setNull(4, -3);
        callableStatement.registerOutParameter(5, 91);
        callableStatement.registerOutParameter(6, 92);
        callableStatement.registerOutParameter(7, 93);
        callableStatement.registerOutParameter(8, -3);
        callableStatement.execute();
        this.assertSameDate(date, calendar, callableStatement.getDate(5, calendar2), calendar2);
        this.assertSameTime(time, calendar, callableStatement.getTime(6, calendar2), calendar2);
        this.vetTimestamp(timestamp, calendar, callableStatement.getTimestamp(7, calendar2), calendar2);
    }

    private void assertSameDate(java.util.Date date, Calendar calendar, java.util.Date date2, Calendar calendar2) {
        calendar.clear();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar2.clear();
        calendar2.setTime(date2);
        CallableTest.assertEquals((String)"year", (int)n, (int)calendar2.get(1));
        CallableTest.assertEquals((String)"month", (int)n2, (int)calendar2.get(2));
        CallableTest.assertEquals((String)"day", (int)n3, (int)calendar2.get(5));
    }

    private void assertSameTime(java.util.Date date, Calendar calendar, java.util.Date date2, Calendar calendar2) {
        calendar.clear();
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        calendar2.clear();
        calendar2.setTime(date2);
        CallableTest.assertEquals((String)"hour", (int)n, (int)calendar2.get(11));
        CallableTest.assertEquals((String)"minute", (int)n2, (int)calendar2.get(12));
        CallableTest.assertEquals((String)"second", (int)n3, (int)calendar2.get(13));
    }

    private void vetTimestamp(Timestamp timestamp, Calendar calendar, Timestamp timestamp2, Calendar calendar2) {
        calendar.clear();
        calendar.setTime(timestamp);
        Calendar calendar3 = Calendar.getInstance();
        calendar3.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        calendar2.clear();
        calendar2.set(calendar3.get(1), calendar3.get(2), calendar3.get(5), calendar3.get(11), calendar3.get(12), calendar3.get(13));
        Timestamp timestamp3 = new Timestamp(calendar2.getTimeInMillis());
        timestamp3.setNanos(timestamp.getNanos());
        CallableTest.assertEquals((Object)timestamp3, (Object)timestamp2);
    }

    public void testManyTypesInoutProc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call MANY_TYPES_INOUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        callableStatement.registerOutParameter(2, 5);
        callableStatement.registerOutParameter(4, 4);
        callableStatement.registerOutParameter(6, -5);
        callableStatement.registerOutParameter(8, 7);
        callableStatement.registerOutParameter(10, 8);
        callableStatement.registerOutParameter(12, 92);
        callableStatement.setShort(1, (short)6);
        callableStatement.setShort(2, (short)9);
        callableStatement.setInt(3, 6);
        callableStatement.setInt(4, 9);
        callableStatement.setLong(5, 99999L);
        callableStatement.setLong(6, 88888888L);
        callableStatement.setFloat(7, 6.123453f);
        callableStatement.setFloat(8, 77777.0f);
        callableStatement.setDouble(9, 6.123453);
        callableStatement.setDouble(10, 8.888888888888012E12);
        callableStatement.setTime(11, Time.valueOf("11:06:03"));
        callableStatement.setTime(12, Time.valueOf("10:05:02"));
        callableStatement.execute();
        CallableTest.assertEquals((String)"Short: Sum of 6 + 9", (int)15, (int)callableStatement.getShort(2));
        CallableTest.assertEquals((String)"Int: Sum of 6 + 9", (int)15, (int)callableStatement.getInt(4));
        CallableTest.assertEquals((String)"Long: Sum of 99999 + 88888888", (long)88988887L, (long)callableStatement.getLong(6));
        CallableTest.assertEquals((String)"Float: Sum of 6.123453 and 77777", (double)77783.125, (double)callableStatement.getFloat(8), (double)1.0E-6);
        CallableTest.assertEquals((String)"Double: Sum of Sum of 6.987654 and 8888888888888.01234", (double)8.888888888894135E12, (double)callableStatement.getDouble(10), (double)1.0E-6);
        CallableTest.assertEquals("Time: changed to", Time.valueOf("11:06:03"), callableStatement.getTime(12));
    }

    public void xtestUpdateLongBinaryProc() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO LONGVARBINARY_TABLE VALUES(X'010305')");
        int n = 50;
        byte[] byArray = new byte[n];
        String string = null;
        for (int i = 0; i < n; ++i) {
            string = Integer.toString(i % 255);
            byArray[i] = Byte.parseByte(string);
        }
        CallableStatement callableStatement = this.prepareCall("CALL UPDATE_LONGVARBINARY_PROC(?)");
        callableStatement.setObject(1, (Object)byArray, -4);
        callableStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("SELECT LVBC FROM LONGVARBINARY_TABLE");
        CallableTest.assertNotNull((String)"SELECT from LONGVARBINARY_TABLE", (Object)resultSet);
        while (resultSet.next()) {
            byte[] byArray2 = (byte[])resultSet.getObject(1);
            CallableTest.assertTrue((boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void xtestBatchUpdate() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(1, 'STRING_1',10)");
        statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(2, 'STRING_2',0)");
        statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(3, 'STRING_3',0)");
        statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(4, 'STRING_4a',0)");
        statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(4, 'STRING_4b',0)");
        CallableStatement callableStatement = this.prepareCall("CALL BATCH_UPDATE_PROC(?,?)");
        callableStatement.setInt(1, 2);
        callableStatement.setInt(2, 20);
        callableStatement.addBatch();
        callableStatement.setInt(1, 3);
        callableStatement.setInt(2, 30);
        callableStatement.addBatch();
        callableStatement.setInt(1, 4);
        callableStatement.setInt(2, 40);
        callableStatement.addBatch();
        callableStatement.setInt(1, 5);
        callableStatement.setInt(2, 50);
        callableStatement.addBatch();
        int[] nArray = null;
        try {
            nArray = callableStatement.executeBatch();
            CallableTest.assertEquals((String)"updateCount length", (int)4, (int)nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                if (CallableTest.usingEmbedded()) {
                    CallableTest.assertEquals((String)"Batch updateCount", (int)0, (int)nArray[0]);
                    continue;
                }
                if (!CallableTest.usingDerbyNetClient()) continue;
                CallableTest.assertEquals((String)"Batch updateCount", (int)-1, (int)nArray[0]);
            }
        }
        catch (BatchUpdateException batchUpdateException) {
            CallableTest.assertSQLState("Unexpected SQL State", batchUpdateException.getSQLState(), batchUpdateException);
        }
        ResultSet resultSet = statement.executeQuery("SELECT id, tag, idval FROM BATCH_TABLE order by id, tag");
        CallableTest.assertNotNull((String)"SELECT from BATCH_TABLE", (Object)resultSet);
        while (resultSet.next()) {
            CallableTest.assertEquals((String)resultSet.getString(2), (int)(resultSet.getInt(1) * 10), (int)resultSet.getInt(3));
        }
    }

    public void xtestBatchUpdateError() throws SQLException {
        Statement statement;
        block14: {
            statement = this.createStatement();
            statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(1, 'STRING_1',0)");
            statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(2, 'STRING_2',0)");
            statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(3, 'STRING_3',0)");
            statement.executeUpdate("INSERT INTO BATCH_TABLE VALUES(4, 'STRING_4',0)");
            CallableStatement callableStatement = this.prepareCall("CALL BATCH_UPDATE_PROC(?,?)");
            callableStatement.setInt(1, 1);
            callableStatement.setInt(2, 10);
            callableStatement.addBatch();
            callableStatement.setInt(1, 2);
            callableStatement.setInt(2, -5);
            callableStatement.addBatch();
            callableStatement.setInt(1, 3);
            callableStatement.setInt(2, 30);
            callableStatement.addBatch();
            callableStatement.setInt(1, 4);
            callableStatement.setInt(2, 40);
            callableStatement.addBatch();
            int[] nArray = null;
            try {
                nArray = callableStatement.executeBatch();
                CallableTest.fail((String)"Expected batchExecute to fail");
            }
            catch (BatchUpdateException batchUpdateException) {
                if (CallableTest.usingEmbedded()) {
                    CallableTest.assertSQLState("38000", batchUpdateException.getSQLState(), batchUpdateException);
                } else if (CallableTest.usingDerbyNetClient()) {
                    CallableTest.assertSQLState("XJ208", batchUpdateException.getSQLState(), batchUpdateException);
                }
                nArray = batchUpdateException.getUpdateCounts();
                if (CallableTest.usingEmbedded()) {
                    CallableTest.assertEquals((String)"updateCount length", (int)1, (int)nArray.length);
                    CallableTest.assertEquals((String)"Batch updateCount", (int)0, (int)nArray[0]);
                }
                if (!CallableTest.usingDerbyNetClient()) break block14;
                CallableTest.assertEquals((String)"updateCount length", (int)4, (int)nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    if (i == 1) {
                        CallableTest.assertEquals((String)"Batch updateCount", (int)-3, (int)nArray[i]);
                        continue;
                    }
                    CallableTest.assertEquals((String)"Batch updateCount", (int)-1, (int)nArray[i]);
                }
            }
        }
        ResultSet resultSet = statement.executeQuery("SELECT id, tag, idval FROM BATCH_TABLE order by id, tag");
        CallableTest.assertNotNull((String)"SELECT from BATCH_TABLE", (Object)resultSet);
        block7: while (resultSet.next()) {
            switch (resultSet.getInt(1)) {
                case 1: {
                    CallableTest.assertEquals((String)resultSet.getString(2), (int)10, (int)resultSet.getInt(3));
                    continue block7;
                }
                case 2: {
                    CallableTest.assertEquals((String)resultSet.getString(2), (int)0, (int)resultSet.getInt(3));
                    continue block7;
                }
            }
            if (CallableTest.usingEmbedded()) {
                CallableTest.assertEquals((String)resultSet.getString(2), (int)0, (int)resultSet.getInt(3));
                continue;
            }
            if (!CallableTest.usingDerbyNetClient()) continue;
            CallableTest.assertEquals((String)resultSet.getString(2), (int)(resultSet.getInt(1) * 10), (int)resultSet.getInt(3));
        }
    }

    public void xtestNumericBoundariesProc() throws SQLException {
        String string = "insert into NUMERIC_BOUNDARIES_TABLE values(999999999999999, 0.000000000000001, null)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        CallableStatement callableStatement = this.prepareCall("CALL NUMERIC_BOUNDARIES_PROC(?,?,?)");
        callableStatement.registerOutParameter(1, 2, 15);
        callableStatement.registerOutParameter(2, 2, 15);
        callableStatement.registerOutParameter(3, 2, 15);
        callableStatement.execute();
        this.assertDecimalSameValue("OUT 1", "999999999999999.000000000000000", callableStatement.getBigDecimal(1));
        this.assertDecimalSameValue("OUT 2", "0.000000000000001", callableStatement.getBigDecimal(2));
        CallableTest.assertNull((String)"Expected OUT 3 to be null", (Object)callableStatement.getBigDecimal(3));
    }

    public void xtestBigDecimalInAndOutProc() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL BIGDECIMAL_IN_AND_OUT_PROC (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        callableStatement.setBigDecimal(1, new BigDecimal("33.333"));
        callableStatement.registerOutParameter(2, 3);
        callableStatement.setBigDecimal(3, new BigDecimal("-999.999999"));
        callableStatement.registerOutParameter(4, 3);
        callableStatement.registerOutParameter(5, 3);
        callableStatement.registerOutParameter(6, 3);
        callableStatement.registerOutParameter(7, 3);
        callableStatement.registerOutParameter(8, 3);
        callableStatement.registerOutParameter(9, 3);
        callableStatement.execute();
        this.assertDecimalSameValue("OUT 2", "33.3330", callableStatement.getBigDecimal(2));
        this.assertDecimalSameValue("OUT 4", "-33332.9966", callableStatement.getBigDecimal(4));
        this.assertDecimalSameValue("OUT 5", "-966.6669", callableStatement.getBigDecimal(5));
        this.assertDecimalSameValue("OUT 6", "0.0000", callableStatement.getBigDecimal(6));
        this.assertDecimalSameValue("OUT 7", "0.0000", callableStatement.getBigDecimal(7));
        this.assertDecimalSameValue("OUT 8", "99999999.0000", callableStatement.getBigDecimal(8));
        this.assertDecimalSameValue("OUT 9", "-99999999.0000", callableStatement.getBigDecimal(9));
    }

    public void assertDecimalSameValue(String string, String string2, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal(string2);
        CallableTest.assertTrue((String)(string + " expected:<" + bigDecimal2 + "> but was:<" + bigDecimal.toString() + ">"), (bigDecimal2.compareTo(bigDecimal) == 0 ? 1 : 0) != 0);
    }

    public static int oneInOneOutFunc(int n) {
        return n * n + n;
    }

    public static void twoInOneOutProc(int n, int n2, int[] nArray) {
        nArray[0] = n + n2;
    }

    public static int noInOneOutFunc() {
        return 55;
    }

    public static void systemOutPrintlnProc() {
        System.out.println("I'm doing something here...");
    }

    public static void updateLongVarbinaryProc(byte[] byArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("update LONGVARBINARY_TABLE set lvbc=?");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void numericBoundariesProc(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select maxcol, mincol, nulcol from NUMERIC_BOUNDARIES_TABLE");
        if (!resultSet.next()) {
            throw new SQLException("Data not found");
        }
        bigDecimalArray[0] = resultSet.getBigDecimal(1);
        bigDecimalArray2[0] = resultSet.getBigDecimal(2);
        bigDecimalArray3[0] = resultSet.getBigDecimal(3);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void bigDecimalInAndOutProc(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray, BigDecimal bigDecimal2, BigDecimal[] bigDecimalArray2, BigDecimal[] bigDecimalArray3, BigDecimal[] bigDecimalArray4, BigDecimal[] bigDecimalArray5, BigDecimal[] bigDecimalArray6, BigDecimal[] bigDecimalArray7) {
        bigDecimalArray[0] = bigDecimal;
        bigDecimalArray2[0] = bigDecimal.multiply(bigDecimal2);
        bigDecimalArray3[0] = bigDecimal.add(bigDecimal2);
        bigDecimalArray4[0] = new BigDecimal(".00000");
        bigDecimalArray5[0] = new BigDecimal("-.00000");
        bigDecimalArray6[0] = new BigDecimal("99999999.");
        bigDecimalArray7[0] = new BigDecimal("-99999999.");
    }

    public static void manyTypesInAndOutProc(short s, int n, long l, float f, double d, BigDecimal bigDecimal, short[] sArray, int[] nArray, long[] lArray, float[] fArray, double[] dArray, BigDecimal[] bigDecimalArray) {
        sArray[0] = s;
        nArray[0] = n;
        lArray[0] = l;
        fArray[0] = f;
        dArray[0] = d;
        bigDecimalArray[0] = bigDecimal;
    }

    public static void manyTypesInAndOutProc(Date date, Time time, Timestamp timestamp, byte[] byArray, Date[] dateArray, Time[] timeArray, Timestamp[] timestampArray, byte[][] byArray2) {
        dateArray[0] = date;
        timeArray[0] = time;
        timestampArray[0] = timestamp;
        byArray2[0] = byArray;
    }

    public static void manyTypesInoutProc(short s, short[] sArray, int n, int[] nArray, long l, long[] lArray, float f, float[] fArray, double d, double[] dArray, Time time, Time[] timeArray) {
        nArray[0] = n + nArray[0];
        sArray[0] = (short)(s + sArray[0]);
        lArray[0] = l + lArray[0];
        fArray[0] = f + fArray[0];
        dArray[0] = d + dArray[0];
        timeArray[0] = time;
    }

    public static void batchUpdateProc(int n, int n2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("update BATCH_TABLE set idval=? where id=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public void testsetURL() throws SQLException, MalformedURLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            URL uRL = new URL("http://www.apache.org");
            callableStatement.setURL("URL", uRL);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNull() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setNull("P1", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetBoolean() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setBoolean("P1", true);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetByte() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            callableStatement.setByte("P1", (byte)1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetShort() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            callableStatement.setShort("P1", (short)1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetInt() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setInt("P1", 6);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetLong() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setLong("P1", 6000L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetFloat() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            callableStatement.setFloat("P1", 6.123453f);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetDouble() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            callableStatement.setDouble("P5", 6.123453);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetDecimal() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?, ?,?,?,?,?,?)");
        try {
            callableStatement.setBigDecimal("P6", new BigDecimal("33.333"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetString() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setString("P4", "test");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetBytes() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setBytes("P1", new byte[]{-32, 79, -48, 32, -22, 58, 105, 16, -94, -40, 8, 0, 43, 48, 48, -99});
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetDate() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.setDate("P1", Date.valueOf("2013-07-13"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetTime() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.setTime("P2", Time.valueOf("10:05:02"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetTimestamp() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.setTimestamp("P3", Timestamp.valueOf("2002-05-12 10:05:02.000000000"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetAsciiStream() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setAsciiStream("PAscii", (InputStream)byteArrayInputStream, 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetBinaryStream() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setBinaryStream("PBinary", (InputStream)byteArrayInputStream, 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetObject() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setObject("P1", (Object)"Object", 1, 2);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetObject1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setObject("P1", (Object)"Object", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetObject2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setObject("P1", (Object)"Object");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetCharacterStream() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setCharacterStream("P1", (Reader)bufferedReader, 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetDate1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.setDate("P1", Date.valueOf("2013-07-13"), Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetTime1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.setTime("P2", Time.valueOf("10:05:02"), Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetTimestamp1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.setTimestamp("P3", Timestamp.valueOf("2002-05-12 10:05:02.000000000"), Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNull1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setNull("P1", 1, "Null");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetString() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getString("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetBoolean() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getBoolean("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetByte() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getByte("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetShort() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getShort("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetInt() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getInt("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetLong() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getLong("P3");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetFloat() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getFloat("P5");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetDouble() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getDouble("P5");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetBytes() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getBytes("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetDate() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getDate("P1");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetTime() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getTime("P2");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetTimestamp() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getTimestamp("P3");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetObject() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getObject("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetBigDecimal() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?,?,?,?,?,?, ?,?)");
        try {
            callableStatement.getBigDecimal("P6");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetObject1() throws SQLException, MalformedURLException {
        HashMap hashMap = new HashMap();
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.getObject("P1", hashMap);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetRef() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getRef("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetBlob() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getBlob("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetClob1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getClob("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetArray() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getArray("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetDate1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getDate("P1", Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetTime1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getTime("P2", Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetTimestamp1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?, ?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getTimestamp("P3", Calendar.getInstance());
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetURL() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC(?,?,?,?,?, ?, ?,?)");
        try {
            callableStatement.getURL("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testregisterOutParameter() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.registerOutParameter("String", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testregisterOutParameter1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.registerOutParameter("String", 1, 2);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testregisterOutParameter2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.registerOutParameter("String", 1);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testregisterOutParameter3() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.registerOutParameter("String1", 1, "String2");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetCharacterStream() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getCharacterStream("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetNCharacterStream() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?, ?, ?,?,?, ?, ?,?)");
        try {
            callableStatement.getNCharacterStream("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetNString() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?, ?, ?,?,?, ?, ?,?)");
        try {
            callableStatement.getNString("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetRowId() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?, ?, ?,?,?, ?, ?,?)");
        try {
            callableStatement.getRowId("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetRowId() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setRowId("P1", callableStatement.getRowId("P2"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetBlob() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setBlob("P1", callableStatement.getBlob("P2"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetClob() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setClob("P1", callableStatement.getClob("P2"));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNString() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setNString("P1", "value");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNCharacterStream1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setNCharacterStream("P1", (Reader)bufferedReader);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNCharacterStream2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setNCharacterStream("P1", (Reader)bufferedReader, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNClob() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setNClob("P1", callableStatement.getNClob(1));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetClob1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setNClob("P1", (Reader)bufferedReader);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetClob2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setNClob("P1", (Reader)bufferedReader, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetClobInputStream1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setBlob("P1", (InputStream)byteArrayInputStream);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetClobInputStream2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setBlob("P1", (InputStream)byteArrayInputStream, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNClobInput1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setNClob("P1", (Reader)bufferedReader);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetNClobInput2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setNClob("P1", (Reader)bufferedReader, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetNClob() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getNClob("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetSQLXML() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            callableStatement.setSQLXML("P1", callableStatement.getSQLXML(1));
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testgetSQLXML() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call NON_NUMERIC_TYPES_IN_AND_OUT_PROC (?,?,?,?,?,?,?,?)");
        try {
            callableStatement.getSQLXML("P4");
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetAsciiStream1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setAsciiStream("P1", (InputStream)byteArrayInputStream);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetAsciiStream2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setAsciiStream("P1", (InputStream)byteArrayInputStream, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetBinaryStream1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setBinaryStream("P1", (InputStream)byteArrayInputStream);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetBinaryStream2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?, ?, ?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            callableStatement.setBinaryStream("P1", (InputStream)byteArrayInputStream, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetCharacterStream1() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?,?,?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setCharacterStream("P1", (Reader)bufferedReader);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }

    public void testsetCharacterStream2() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("call TWO_IN_ONE_OUT_PROC (?,?,?)");
        try {
            String string = "This is a String";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            callableStatement.setCharacterStream("P1", (Reader)bufferedReader, 345678788L);
            CallableTest.fail((String)"should have failed");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            CallableTest.assertSQLState("0A000", sQLFeatureNotSupportedException);
        }
    }
}

