/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public class DynamicByteArrayOutputStream
extends OutputStream {
    private static int INITIAL_SIZE = 4096;
    private byte[] buf;
    private int position;
    private int used;
    private int beginPosition;

    public DynamicByteArrayOutputStream() {
        this(INITIAL_SIZE);
    }

    public DynamicByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    public DynamicByteArrayOutputStream(byte[] data) {
        this.buf = data;
    }

    public DynamicByteArrayOutputStream(DynamicByteArrayOutputStream toBeCloned) {
        byte[] cbuf = toBeCloned.getByteArray();
        this.buf = new byte[cbuf.length];
        this.write(cbuf, 0, cbuf.length);
        this.position = toBeCloned.getPosition();
        this.used = toBeCloned.getUsed();
        this.beginPosition = toBeCloned.getBeginPosition();
    }

    @Override
    public void write(int b) {
        if (this.position >= this.buf.length) {
            this.expandBuffer(INITIAL_SIZE);
        }
        this.buf[this.position++] = (byte)b;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.position + len > this.buf.length) {
            this.expandBuffer(len);
        }
        System.arraycopy(b, off, this.buf, this.position, len);
        this.position += len;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    void writeCompleteStream(InputStream dataIn, int len) throws IOException {
        if (this.position + len > this.buf.length) {
            this.expandBuffer(len);
        }
        InputStreamUtil.readFully(dataIn, this.buf, this.position, len);
        this.position += len;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    @Override
    public void close() {
        this.buf = null;
        this.reset();
    }

    public void reset() {
        this.position = 0;
        this.beginPosition = 0;
        this.used = 0;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public int getUsed() {
        return this.used;
    }

    public int getPosition() {
        return this.position;
    }

    public int getBeginPosition() {
        return this.beginPosition;
    }

    public void setPosition(int newPosition) {
        if (newPosition > this.position && newPosition > this.buf.length) {
            this.expandBuffer(newPosition - this.buf.length);
        }
        this.position = newPosition;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    public void setBeginPosition(int newBeginPosition) {
        if (newBeginPosition > this.buf.length) {
            return;
        }
        this.beginPosition = newBeginPosition;
    }

    public void discardLeft(int amountToShrinkBy) {
        System.arraycopy(this.buf, amountToShrinkBy, this.buf, 0, this.used - amountToShrinkBy);
        this.position -= amountToShrinkBy;
        this.used -= amountToShrinkBy;
    }

    private void expandBuffer(int minExtension) {
        if (this.buf.length < 131072) {
            if (minExtension < INITIAL_SIZE) {
                minExtension = INITIAL_SIZE;
            }
        } else if (this.buf.length < 0x100000) {
            if (minExtension < 131072) {
                minExtension = 131072;
            }
        } else if (minExtension < 0x100000) {
            minExtension = 0x100000;
        }
        int newsize = this.buf.length + minExtension;
        byte[] newbuf = new byte[newsize];
        System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
        this.buf = newbuf;
    }
}

