/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class ShutdownDatabaseTest
extends BaseJDBCTestCase {
    public ShutdownDatabaseTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(ShutdownDatabaseTest.class, "ShutdownDatabaseTest"));
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table TEST_TABLE ( TEST_COL integer )");
        this.commit();
        this.insertIntoTestTable(1, 1000);
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("DROP TABLE TEST_TABLE");
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testOnlyTransactionWasCommited() throws SQLException {
        this.commit();
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "1000");
        statement.close();
    }

    public void testTwiceCommited() throws SQLException {
        this.commit();
        this.insertIntoTestTable(1001, 999);
        this.commit();
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "1999");
        statement.close();
    }

    public void testOnceRollbackedAndCommited() throws SQLException {
        this.rollback();
        this.insertIntoTestTable(1001, 999);
        this.commit();
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "999");
        statement.close();
    }

    public void testOnlyTransactionWasRollbacked() throws SQLException {
        this.rollback();
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "0");
        statement.close();
    }

    public void testOnceCommitedAndRollbacked() throws SQLException {
        this.commit();
        this.insertIntoTestTable(1001, 999);
        this.rollback();
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "1000");
        statement.close();
    }

    public void testTwiceRollbacked() throws SQLException {
        this.rollback();
        this.insertIntoTestTable(1001, 999);
        this.rollback();
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "0");
        statement.close();
    }

    public void testOnlyTransactionWasLeft() throws SQLException {
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "0");
        statement.close();
    }

    public void testOnceCommitedAndLeft() throws SQLException {
        this.commit();
        this.insertIntoTestTable(1001, 999);
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "1000");
        statement.close();
    }

    public void testOnceRollbackedAndLeft() throws SQLException {
        this.rollback();
        this.insertIntoTestTable(1001, 999);
        this.assertShutdownOK();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from TEST_TABLE "), "0");
        statement.close();
    }

    protected void insertIntoTestTable(int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatement("insert into TEST_TABLE ( TEST_COL ) values( ? )");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
                preparedStatement = null;
            }
        }
    }

    private void insertIntoTestTable(int n, int n2) throws SQLException {
        for (int i = n; i < n + n2; ++i) {
            this.insertIntoTestTable(i);
        }
    }

    protected void assertShutdownOK() throws SQLException {
        Connection connection = this.getConnection();
        if (ShutdownDatabaseTest.usingEmbedded()) {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
            try {
                dataSource.getConnection();
                ShutdownDatabaseTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException sQLException) {
                ShutdownDatabaseTest.assertSQLState("08006", sQLException);
            }
            ShutdownDatabaseTest.assertTrue((boolean)connection.isClosed());
        } else if (ShutdownDatabaseTest.usingDerbyNetClient()) {
            ClientDataSource clientDataSource = (ClientDataSource)JDBCDataSource.getDataSource();
            clientDataSource.setConnectionAttributes("shutdown=true");
            try {
                clientDataSource.getConnection();
                ShutdownDatabaseTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException sQLException) {
                ShutdownDatabaseTest.assertSQLState("08006", sQLException);
            }
        }
    }
}

