/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.File;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.derbyTesting.functionTests.tests.compatibility.VersionCombinationConfigurator;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientCompatibilityRunControl
extends BaseJDBCTestCase {
    static final String LOB_TESTING_PROP = "derby.tests.compat.testLOBs";
    private final String realName;
    private final DerbyDistribution clientDist;
    private final DerbyVersion serverVersion;
    private final String testingPath;

    public ClientCompatibilityRunControl(DerbyDistribution derbyDistribution, String string, DerbyVersion derbyVersion) {
        super("testClient");
        this.clientDist = derbyDistribution;
        this.testingPath = string;
        this.serverVersion = derbyVersion;
        this.realName = "combination(client " + derbyDistribution.getVersion().toString() + " <> server " + derbyVersion.toString() + ")";
    }

    public String getName() {
        return this.realName;
    }

    public void testClient() throws Exception {
        boolean bl = Boolean.parseBoolean(ClientCompatibilityRunControl.getSystemProperty(LOB_TESTING_PROP));
        String string = this.clientDist.getDerbyClientJarPath() + File.pathSeparator + this.testingPath + File.pathSeparator + ClientCompatibilityRunControl.getJUnitPath();
        if (bl) {
            string = string + File.pathSeparator + this.clientDist.getDerbyEngineJarPath();
        }
        String[] stringArray = new String[]{"-Dderby.tests.compat.expectedClient=" + this.clientDist.getVersion().toString(), "-Dderby.tests.compat.expectedServer=" + this.serverVersion.toString(), "-Dderby.tests.compat.testLOBs=" + bl, "-Dderby.tests.basePort=" + TestConfiguration.getBasePort(), "junit.textui.TestRunner", "org.apache.derbyTesting.functionTests.tests.compatibility.ClientCompatibilitySuite"};
        Process process = ClientCompatibilityRunControl.execJavaCmd(null, string, stringArray, null);
        SpawnedProcess spawnedProcess = new SpawnedProcess(process, this.realName);
        int n = spawnedProcess.complete(1800000L);
        ClientCompatibilityRunControl.assertTrue((String)spawnedProcess.getFailMessage("client VM failed: "), (n == 0 ? 1 : 0) != 0);
        ClientCompatibilityRunControl.println(spawnedProcess.getFullServerOutput());
    }

    private static String getJUnitPath() {
        URI uRI = VersionCombinationConfigurator.getClassURI(TestCase.class);
        return new File(uRI).getPath();
    }
}

