/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class PositionedStoreStreamTest
extends BaseTestCase {
    public PositionedStoreStreamTest(String string) {
        super(string);
    }

    public void testPositionAfterEOFRead() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(10L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.getPosition());
        for (int i = 0; i < 10; ++i) {
            positionedStoreStream.read();
            PositionedStoreStreamTest.assertEquals((long)(i + 1), (long)positionedStoreStream.getPosition());
        }
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read());
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read());
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.skip(199L));
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        positionedStoreStream.resetStream();
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.getPosition());
    }

    public void testPositionAfterEOFReadArray() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(10L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.getPosition());
        byte[] byArray = new byte[2];
        for (int i = 0; i < 10; i += 2) {
            PositionedStoreStreamTest.assertEquals((int)2, (int)positionedStoreStream.read(byArray, 0, 2));
            PositionedStoreStreamTest.assertEquals((long)(i + 2), (long)positionedStoreStream.getPosition());
        }
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read(byArray, 0, 2));
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read(byArray, 0, 2));
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.skip(21L));
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read());
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        positionedStoreStream.resetStream();
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.getPosition());
    }

    public void testReadEverythingInOneGo() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(127L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream);
        byte[] byArray = new byte[256];
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(byArray, (byte)-1);
            PositionedStoreStreamTest.assertEquals((int)127, (int)positionedStoreStream.read(byArray, 0, 256));
            PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read(byArray, 127, 10));
            PositionedStoreStreamTest.assertEquals((int)-1, (int)byArray[127]);
            PositionedStoreStreamTest.assertTrue((-1 != byArray[126] ? 1 : 0) != 0);
            PositionedStoreStreamTest.assertEquals((int)97, (int)byArray[0]);
            positionedStoreStream.reposition(0L);
        }
    }

    public void testRepositionForwards() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream;
        LoopingAlphabetStream loopingAlphabetStream2 = new LoopingAlphabetStream(20L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream2);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.getPosition());
        int n = 0;
        while ((long)n < 20L) {
            loopingAlphabetStream = new LoopingAlphabetStream(20L);
            positionedStoreStream.reposition((long)n);
            loopingAlphabetStream.skip(n);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)loopingAlphabetStream).read(), (int)positionedStoreStream.read());
            ++n;
        }
        n = 1;
        while ((long)n < 20L) {
            loopingAlphabetStream = new LoopingAlphabetStream(20L);
            positionedStoreStream.reposition((long)n);
            loopingAlphabetStream.skip(n);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)loopingAlphabetStream).read(), (int)positionedStoreStream.read());
            n += 2;
        }
    }

    public void testRepositionBackwards() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream;
        int n;
        LoopingAlphabetStream loopingAlphabetStream2 = new LoopingAlphabetStream(20L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream2);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)positionedStoreStream.getPosition());
        for (n = 20; n >= 0; --n) {
            loopingAlphabetStream = new LoopingAlphabetStream(20L);
            positionedStoreStream.reposition((long)n);
            loopingAlphabetStream.skip(n);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)loopingAlphabetStream).read(), (int)positionedStoreStream.read());
        }
        for (n = 19; n >= 0; n -= 2) {
            loopingAlphabetStream = new LoopingAlphabetStream(20L);
            positionedStoreStream.reposition((long)n);
            loopingAlphabetStream.skip(n);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)loopingAlphabetStream).read(), (int)positionedStoreStream.read());
        }
    }

    public void testSimpleReadSequence() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(26L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream);
        PositionedStoreStreamTest.assertEquals((int)97, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(9L);
        PositionedStoreStreamTest.assertEquals((int)106, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(10L);
        PositionedStoreStreamTest.assertEquals((int)107, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(9L);
        PositionedStoreStreamTest.assertEquals((int)106, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(25L);
        PositionedStoreStreamTest.assertEquals((int)122, (int)positionedStoreStream.read());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(1L);
        PositionedStoreStreamTest.assertEquals((int)98, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(1L);
        PositionedStoreStreamTest.assertEquals((int)98, (int)positionedStoreStream.read());
    }

    public void testDerby3735() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(2L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream);
        byte[] byArray = new byte[2];
        for (int i = 0; i < 10; ++i) {
            positionedStoreStream.read(byArray);
            PositionedStoreStreamTest.println("Position at iteration " + i + ": " + positionedStoreStream.getPosition());
        }
        positionedStoreStream.reposition(0L);
    }

    public void testDerby3781() throws IOException, StandardException {
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(10L);
        PositionedStoreStream positionedStoreStream = new PositionedStoreStream((InputStream)loopingAlphabetStream);
        PositionedStoreStreamTest.assertEquals((String)"Invalid initial position", (long)0L, (long)positionedStoreStream.getPosition());
        positionedStoreStream.reposition(9L);
        PositionedStoreStreamTest.assertEquals((long)9L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)106, (int)positionedStoreStream.read());
        PositionedStoreStreamTest.assertEquals((long)10L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)positionedStoreStream.read());
        positionedStoreStream.reposition(5L);
        PositionedStoreStreamTest.assertEquals((long)5L, (long)positionedStoreStream.getPosition());
        try {
            positionedStoreStream.reposition(20L);
            PositionedStoreStreamTest.fail((String)"Should have failed with EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        positionedStoreStream.reposition(9L);
        PositionedStoreStreamTest.assertEquals((long)9L, (long)positionedStoreStream.getPosition());
        PositionedStoreStreamTest.assertEquals((int)106, (int)positionedStoreStream.read());
    }

    public static Test suite() {
        return new BaseTestSuite(PositionedStoreStreamTest.class, "PositionedStoreStreamTest");
    }
}

