/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepareExecuteDDL
extends BaseJDBCTestCase {
    private Connection connDDL;
    private static final String[] STMTS = new String[]{"SELECT * FROM PED001", "SELECT A, B FROM PED001", "GRANT SELECT ON PED001 TO U_PED_001", "GRANT SELECT(A,B) ON PED001 TO U_PED_001", "REVOKE SELECT(A,B) ON PED001 FROM U_PED_001", "REVOKE SELECT ON PED001 FROM U_PED_001"};
    private static final String[] DDL = new String[]{"ALTER TABLE PED001 ADD COLUMN D BIGINT", "ALTER TABLE PED001 ADD CONSTRAINT PED001_PK PRIMARY KEY (A)", "ALTER TABLE PED001 LOCKSIZE ROW", "ALTER TABLE PED001 LOCKSIZE TABLE", "DROP TABLE PED001"};
    private final String ddl;

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("PrepareExecuteDDL");
        for (int i = 0; i < DDL.length; ++i) {
            baseTestSuite.addTest((Test)new PrepareExecuteDDL("testPrepareExcute", DDL[i]));
        }
        return TestConfiguration.sqlAuthorizationDecorator((Test)baseTestSuite);
    }

    private PrepareExecuteDDL(String string, String string2) {
        super(string);
        this.ddl = string2;
    }

    private boolean tableDropped() {
        return this.ddl.startsWith("DROP TABLE ");
    }

    public void testPrepareExcute() throws SQLException {
        String string;
        int n;
        Connection connection = this.getConnection();
        PreparedStatement[] preparedStatementArray = new PreparedStatement[STMTS.length];
        for (n = 0; n < STMTS.length; ++n) {
            string = STMTS[n];
            preparedStatementArray[n] = connection.prepareStatement(string);
        }
        this.connDDL.createStatement().execute(this.ddl);
        for (n = 0; n < STMTS.length; ++n) {
            string = STMTS[n];
            if (string.startsWith("SELECT ")) {
                this.checkSelect(preparedStatementArray[n], string);
            } else if (string.startsWith("GRANT ") || string.startsWith("REVOKE ")) {
                this.checkGrantRevoke(preparedStatementArray[n], string);
            } else {
                PrepareExecuteDDL.fail((String)("unknown SQL" + string));
            }
            preparedStatementArray[n].close();
        }
    }

    private void checkSelect(PreparedStatement preparedStatement, String string) throws SQLException {
        boolean bl;
        PrepareExecuteDDL.assertEquals((boolean)true, (boolean)string.startsWith("SELECT "));
        try {
            bl = preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            PrepareExecuteDDL.assertSQLState("42X05", sQLException);
            PrepareExecuteDDL.assertTrue((boolean)this.tableDropped());
            return;
        }
        PrepareExecuteDDL.assertTrue((boolean)bl);
        ResultSet resultSet = preparedStatement.getResultSet();
        DatabaseMetaData databaseMetaData = this.connDDL.getMetaData();
        JDBC.assertMetaDataMatch(databaseMetaData, resultSet.getMetaData());
        boolean bl2 = string.startsWith("SELECT * ");
        if (bl2) {
            // empty if block
        }
        JDBC.assertDrainResults(resultSet);
    }

    private void checkGrantRevoke(PreparedStatement preparedStatement, String string) throws SQLException {
        PrepareExecuteDDL.assertEquals((boolean)true, (string.startsWith("GRANT ") || string.startsWith("REVOKE ") ? 1 : 0) != 0);
        try {
            PrepareExecuteDDL.assertFalse((boolean)preparedStatement.execute());
        }
        catch (SQLException sQLException) {
            PrepareExecuteDDL.assertSQLState("42X05", sQLException);
            PrepareExecuteDDL.assertTrue((boolean)this.tableDropped());
            return;
        }
    }

    protected void setUp() throws SQLException {
        this.connDDL = this.openDefaultConnection();
        Statement statement = this.connDDL.createStatement();
        statement.execute("CREATE TABLE PED001 (A INT NOT NULL, B DECIMAL(6,4), C VARCHAR(20))");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.connDDL.createStatement();
        try {
            statement.execute("DROP TABLE PED001");
        }
        catch (SQLException sQLException) {
            PrepareExecuteDDL.assertSQLState("42Y55", sQLException);
        }
        statement.close();
        JDBC.cleanup(this.connDDL);
        this.connDDL = null;
        super.tearDown();
    }
}

