/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobStreamTest
extends BaseJDBCTestCase {
    private InputStream in = null;
    private OutputStream out = null;
    private Blob blob;

    public LobStreamTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        Connection connection = this.getConnection();
        this.blob = connection.createBlob();
        this.in = this.blob.getBinaryStream();
        this.out = this.blob.setBinaryStream(1L);
    }

    @Override
    protected void tearDown() throws Exception {
        this.blob.free();
        this.blob = null;
        super.tearDown();
    }

    public void testReadWriteNoParameters() throws IOException {
        int n;
        for (n = 0; n < 8000; ++n) {
            this.out.write(n % 255);
        }
        for (n = 0; n < 8000; ++n) {
            int n2 = this.in.read();
            LobStreamTest.assertEquals((String)"Output does not match input", (int)(n % 255), (int)n2);
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testReadNoParameterWriteOneParameter() throws IOException {
        int n;
        byte[] byArray = new byte[100];
        for (n = 0; n < 8000; ++n) {
            byArray[n % 100] = (byte)((byte)(n % 255) & 0xFF);
            if (n % 100 != 99) continue;
            this.out.write(byArray);
        }
        for (n = 0; n < 8000; ++n) {
            int n2 = this.in.read();
            LobStreamTest.assertEquals((String)"Output does not match input", (int)(n % 255), (int)n2);
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testReadWriteOneParameter() throws IOException {
        int n;
        byte[] byArray = new byte[100];
        for (n = 0; n < 8000; ++n) {
            byArray[n % 100] = (byte)((byte)(n % 255) & 0xFF);
            if (n % 100 != 99) continue;
            this.out.write(byArray);
        }
        for (n = 0; n < 80; ++n) {
            int n2 = this.in.read(byArray);
            for (int i = 0; i < n2; ++i) {
                int n3 = byArray[i] & 0xFF;
                LobStreamTest.assertEquals((String)"Output does not match input", (int)((n * 100 + i) % 255), (int)n3);
            }
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testReadWriteThreeParameter() throws IOException {
        int n;
        byte[] byArray = new byte[200];
        int n2 = 0;
        for (n = 0; n < 8000; ++n) {
            byArray[n % 100 + n2] = (byte)((byte)(n % 255) & 0xFF);
            if (n % 100 != 99) continue;
            this.out.write(byArray, n2, 100);
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < 80; ++n) {
            int n3 = this.in.read(byArray, n2, 100);
            for (int i = 0; i < n3; ++i) {
                int n4 = byArray[i + n2] & 0xFF;
                LobStreamTest.assertEquals((String)"Output does not match input", (int)((n * 100 + i) % 255), (int)n4);
            }
            ++n2;
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testEndOfStreamValue() throws IOException {
        int n;
        for (n = 0; n < 8000; ++n) {
            this.out.write(n % 255);
        }
        n = 0;
        while (this.in.read() != -1) {
            ++n;
        }
        LobStreamTest.assertEquals((String)"All values have been read", (int)8000, (int)n);
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testEndOfStreamOnReadOneParameter() throws IOException {
        int n;
        for (n = 0; n < 8050; ++n) {
            this.out.write(n % 255);
        }
        n = 0;
        int n2 = 0;
        byte[] byArray = new byte[100];
        LobStreamTest.assertTrue((String)"b.length should not be = 0", (byArray.length != 0 ? 1 : 0) != 0);
        while ((n = this.in.read(byArray)) != -1) {
            LobStreamTest.assertTrue((String)"Number of bytes read can not be = 0", (n != 0 ? 1 : 0) != 0);
            n2 += n;
        }
        LobStreamTest.assertEquals((String)"All values have been read", (int)8050, (int)n2);
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testEndOfStreamOnReadThreeParameters() throws IOException {
        int n;
        for (n = 0; n < 8050; ++n) {
            this.out.write(n % 255);
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[200];
        LobStreamTest.assertTrue((String)"b.length should not be = 0", (byArray.length != 0 ? 1 : 0) != 0);
        while ((n = this.in.read(byArray, n3, 100)) != -1) {
            LobStreamTest.assertTrue((String)"Number of bytes read can not be = 0", (n != 0 ? 1 : 0) != 0);
            n2 += n;
            ++n3;
        }
        LobStreamTest.assertEquals((String)"All values have been read", (int)8050, (int)n2);
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testSkip() throws IOException {
        int n;
        for (n = 0; n < 8000; ++n) {
            this.out.write(n % 255);
        }
        n = 0;
        while (n < 8000) {
            if (n % 255 < 100) {
                int n2 = this.in.read();
                LobStreamTest.assertEquals((String)"Output does not match input", (int)(n % 255), (int)n2);
                ++n;
                continue;
            }
            long l = this.in.skip(155L);
            n = (int)((long)n + l);
        }
        this.in.close();
        this.out.close();
        this.in = null;
        this.out = null;
    }

    public void testWriteWithInvalidParameterValues() throws IOException {
        for (int i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        byte[] byArray = null;
        try {
            this.out.write(byArray, 100, 20);
            LobStreamTest.fail((String)"byte[] = null should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected NullPointerException", (boolean)(exception instanceof NullPointerException));
        }
        byArray = new byte[100];
        try {
            this.out.write(byArray, 0, 200);
            LobStreamTest.fail((String)"length > b.length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(byArray, 150, 0);
            LobStreamTest.fail((String)"offset > b.length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(byArray, 50, 100);
            LobStreamTest.fail((String)"length + offset > b.length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(byArray, -50, 100);
            LobStreamTest.fail((String)"negative offset should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(byArray, 0, -100);
            LobStreamTest.fail((String)"negative length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        this.out.close();
        try {
            this.out.write(byArray, 0, 100);
            LobStreamTest.fail((String)"Stream should be closed");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IOException", (boolean)(exception instanceof IOException));
        }
        this.out = null;
        this.in.close();
        this.in = null;
    }

    public void testReadWithInvalidParameterValues() throws IOException {
        for (int i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        this.out.close();
        this.out = null;
        byte[] byArray = null;
        try {
            this.in.read(byArray, 100, 20);
            LobStreamTest.fail((String)"byte[] = null should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected NullPointerException", (boolean)(exception instanceof NullPointerException));
        }
        byArray = new byte[100];
        try {
            int n = this.in.read(byArray, 0, 200);
            LobStreamTest.fail((String)"length > b.length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.in.read(byArray, 150, 0);
            LobStreamTest.fail((String)"offset > b.length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            int n = this.in.read(byArray, 50, 100);
            LobStreamTest.fail((String)"offset + length > b.length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.in.read(byArray, -50, 100);
            LobStreamTest.fail((String)"negative offset should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        try {
            this.in.read(byArray, 0, -100);
            LobStreamTest.fail((String)"negative length should cause exception");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(exception instanceof IndexOutOfBoundsException));
        }
        this.in.close();
        try {
            this.in.read(byArray, 0, 100);
            LobStreamTest.fail((String)"Stream should be closed");
        }
        catch (Exception exception) {
            LobStreamTest.assertTrue((String)"Expected IOException", (boolean)(exception instanceof IOException));
        }
        this.in = null;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LobStreamTest");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(LobStreamTest.class));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("LobStreamsTest:encrypted");
        baseTestSuite2.addTestSuite(LobStreamTest.class);
        baseTestSuite.addTest(Decorator.encryptedDatabase((Test)baseTestSuite2));
        return baseTestSuite;
    }
}

