/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Conn;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionMethodsTest
extends Wrapper41Test {
    public static final String CLOSED_CONNECTION = "08003";
    FileInputStream is;

    public ConnectionMethodsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ConnectionMethodsTest");
        baseTestSuite.addTest(ConnectionMethodsTest.baseSuite("ConnectionMethodsTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ConnectionMethodsTest.baseSuite("ConnectionMethodsTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(ConnectionMethodsTest.class, string);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/testData/ConnectionMethods/short.txt"});
        return new CleanDatabaseTestSetup((Test)supportFilesSetup){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table clobtable2(n int,clobcol CLOB)");
                statement.execute("create table blobtable2(n int,blobcol BLOB)");
                statement.execute("create table abort_table(a int)");
                statement.execute("create schema foo");
                statement.execute("create table foo.set_schema_table( a int )");
            }
        };
    }

    public void testCreateClob() throws SQLException, FileNotFoundException, IOException, Exception {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into clobtable2 (n, clobcol) values(?,?)");
        preparedStatement.setInt(1, 1000);
        Clob clob = connection.createClob();
        try {
            this.is = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream("extin/short.txt");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
        OutputStream outputStream = clob.setAsciiStream(1L);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this.is.read();
        while (n > 0) {
            outputStream.write(n);
            arrayList.add(n);
            n = this.is.read();
        }
        preparedStatement.setClob(2, clob);
        preparedStatement.executeUpdate();
        Statement statement2 = this.createStatement();
        ResultSet resultSet = statement2.executeQuery("select clobcol from clobtable2 where n = 1000");
        ConnectionMethodsTest.assertTrue((boolean)resultSet.next());
        clob = resultSet.getClob(1);
        ConnectionMethodsTest.assertEquals((long)arrayList.size(), (long)clob.length());
        InputStream inputStream = clob.getAsciiStream();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = inputStream.read();
        while (n2 > -1) {
            arrayList2.add(n2);
            n2 = inputStream.read();
        }
        ConnectionMethodsTest.assertEquals((int)arrayList.size(), (int)arrayList2.size());
        int n3 = 0;
        while ((long)n3 < clob.length()) {
            ConnectionMethodsTest.assertEquals(arrayList.get(n3), arrayList2.get(n3));
            ++n3;
        }
        outputStream.close();
        this.is.close();
    }

    public void testCreateBlob() throws SQLException, FileNotFoundException, IOException, Exception {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into blobtable2 (n, blobcol) values(?,?)");
        preparedStatement.setInt(1, 1000);
        Blob blob = connection.createBlob();
        try {
            this.is = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream("extin/short.txt");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
        OutputStream outputStream = blob.setBinaryStream(1L);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int n2 = this.is.read();
        while (n2 > 0) {
            outputStream.write(n2);
            arrayList.add(n2);
            n2 = this.is.read();
            ++n;
        }
        preparedStatement.setBlob(2, blob);
        preparedStatement.executeUpdate();
        Statement statement2 = this.createStatement();
        ResultSet resultSet = statement2.executeQuery("select blobcol from blobtable2 where n = 1000");
        ConnectionMethodsTest.assertTrue((boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        ConnectionMethodsTest.assertEquals((long)arrayList.size(), (long)blob.length());
        InputStream inputStream = blob.getBinaryStream();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n3 = inputStream.read();
        while (n3 > -1) {
            arrayList2.add(n3);
            n3 = inputStream.read();
        }
        ConnectionMethodsTest.assertEquals((int)arrayList.size(), (int)arrayList2.size());
        int n4 = 0;
        while ((long)n4 < blob.length()) {
            ConnectionMethodsTest.assertEquals(arrayList.get(n4), arrayList2.get(n4));
            ++n4;
        }
        outputStream.close();
        this.is.close();
    }

    public void testConnectionIsValid() throws SQLException, Exception {
        Connection connection = this.getConnection();
        try {
            connection.isValid(-1);
            ConnectionMethodsTest.fail((String)"FAIL: isValid(-1): Invalid argument execption not thrown");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState("XJ081", sQLException);
        }
        if (!connection.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0): returned false");
        }
        if (!connection.isValid(200)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(200): returned false");
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, sQLException);
        }
        if (connection.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on closed connection: returned true");
        }
        if (!(connection = this.getConnection()).isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on open connection: returned false");
        }
        TestConfiguration.getCurrent().shutdownDatabase();
        if (connection.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on stopped database: returned true");
        }
        if (!(connection = this.getConnection()).isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on new connection: returned false");
        }
        if (!ConnectionMethodsTest.usingEmbedded()) {
            TestConfiguration.getCurrent().stopNetworkServer();
            if (connection.isValid(0)) {
                ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on stopped database: returned true");
            }
            TestConfiguration.getCurrent().startNetworkServer();
            connection = this.getConnection();
            if (!connection.isValid(0)) {
                ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on new connection: returned false");
            }
        }
    }

    public void testAbortPhysical() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        Connection connection = this.openUserConnection("user0");
        Connection connection2 = this.openUserConnection("user1");
        Connection connection3 = this.openUserConnection("user2");
        this.abortVetter(connection, connection2, connection3);
    }

    public void testAbortPooled() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = this.getPooledConnection(connectionPoolDataSource, "user0");
        PooledConnection pooledConnection2 = this.getPooledConnection(connectionPoolDataSource, "user1");
        PooledConnection pooledConnection3 = this.getPooledConnection(connectionPoolDataSource, "user2");
        this.abortVetter(pooledConnection.getConnection(), pooledConnection2.getConnection(), pooledConnection3.getConnection());
        try {
            pooledConnection2.getConnection();
            ConnectionMethodsTest.fail((String)"Expected physical connection to be closed.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, sQLException);
        }
    }

    private PooledConnection getPooledConnection(ConnectionPoolDataSource connectionPoolDataSource, String string) throws Exception {
        return connectionPoolDataSource.getPooledConnection(string, this.getTestConfiguration().getPassword(string));
    }

    public void testAbortXA() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = this.getXAConnection(xADataSource, "user0");
        XAConnection xAConnection2 = this.getXAConnection(xADataSource, "user1");
        XAConnection xAConnection3 = this.getXAConnection(xADataSource, "user2");
        this.abortVetter(xAConnection.getConnection(), xAConnection2.getConnection(), xAConnection3.getConnection());
        try {
            xAConnection2.getConnection();
            ConnectionMethodsTest.fail((String)"Expected physical connection to be closed.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, sQLException);
        }
    }

    private XAConnection getXAConnection(XADataSource xADataSource, String string) throws Exception {
        return xADataSource.getXAConnection(string, this.getTestConfiguration().getPassword(string));
    }

    public void abortVetter(Connection connection, Connection connection2, Connection connection3) throws Exception {
        connection.close();
        Wrapper41Conn wrapper41Conn = new Wrapper41Conn(connection);
        wrapper41Conn.abort(new DirectExecutor());
        connection2.setAutoCommit(false);
        final Wrapper41Conn wrapper41Conn2 = new Wrapper41Conn(connection2);
        try {
            wrapper41Conn2.abort(null);
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState("XCZ02", sQLException);
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection2, "insert into app.abort_table( a ) values ( 1 )");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection2, "select * from app.abort_table");
        ResultSet resultSet = preparedStatement.executeQuery();
        ConnectionMethodsTest.assertTrue((boolean)resultSet.next());
        resultSet.close();
        preparedStatement.close();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DirectExecutor directExecutor = new DirectExecutor();
                    wrapper41Conn2.abort(directExecutor);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            connection2.rollback();
            ConnectionMethodsTest.fail((String)"Could not abort connection!");
        }
        try {
            this.prepareStatement(connection2, "select * from sys.systables");
            ConnectionMethodsTest.fail((String)"Connection should be dead!");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, sQLException);
        }
        preparedStatement = this.prepareStatement(connection3, "select * from app.abort_table");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        ConnectionMethodsTest.assertFalse((boolean)resultSet2.next());
        resultSet2.close();
        preparedStatement.close();
        connection3.close();
    }

    public void testGetSetSchema() throws Exception {
        Connection connection = this.getConnection();
        ConnectionMethodsTest.println("Testing get/setSchema() on a " + connection.getClass().getName());
        Wrapper41Conn wrapper41Conn = new Wrapper41Conn(connection);
        ConnectionMethodsTest.assertEquals((String)"APP", (String)wrapper41Conn.getSchema());
        try {
            this.prepareStatement("select * from set_schema_table");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState("42X05", sQLException);
        }
        wrapper41Conn.setSchema("FOO");
        ConnectionMethodsTest.assertEquals((String)"FOO", (String)wrapper41Conn.getSchema());
        this.prepareStatement("select * from set_schema_table");
        try {
            wrapper41Conn.setSchema("foo");
            ConnectionMethodsTest.fail((String)"Should not have been able to change to a non-existent schema.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState("42Y07", sQLException);
        }
        connection.close();
        try {
            wrapper41Conn.setSchema("APP");
            ConnectionMethodsTest.fail((String)"Should fail on a closed connection.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, sQLException);
        }
        try {
            wrapper41Conn.getSchema();
            ConnectionMethodsTest.fail((String)"Should fail on a closed connection.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, sQLException);
        }
    }

    public void testGetSetNetworkTimeout() throws Exception {
        Connection connection = this.getConnection();
        ConnectionMethodsTest.println("Testing get/setNetoworkTimeout() on a " + connection.getClass().getName());
        Wrapper41Conn wrapper41Conn = new Wrapper41Conn(connection);
        try {
            wrapper41Conn.getNetworkTimeout();
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)sQLException.getClass().getName());
        }
        try {
            wrapper41Conn.setNetworkTimeout(null, 3);
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)sQLException.getClass().getName());
        }
        connection.close();
        try {
            wrapper41Conn.getNetworkTimeout();
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)sQLException.getClass().getName());
        }
        try {
            wrapper41Conn.setNetworkTimeout(null, 3);
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException sQLException) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)sQLException.getClass().getName());
        }
    }

    public static final class DirectExecutor
    implements Executor {
        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

