/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.io.StorageFile;

public class RemoveFileOperation
implements Undoable {
    private String name;
    private long generationId;
    private boolean removeAtOnce;
    private transient StorageFile fileToGo;

    public RemoveFileOperation() {
    }

    RemoveFileOperation(String name, long generationId, boolean removeAtOnce) {
        this.name = name;
        this.generationId = generationId;
        this.removeAtOnce = removeAtOnce;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.generationId);
        out.writeBoolean(this.removeAtOnce);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.generationId = in.readLong();
        this.removeAtOnce = in.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 291;
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void releaseResource(Transaction tran) {
    }

    @Override
    public int group() {
        return 1280;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException {
        if (this.fileToGo == null) {
            return;
        }
        BaseDataFileFactory bdff = (BaseDataFileFactory)((RawTransaction)xact).getDataFactory();
        bdff.fileToRemove(this.fileToGo, true);
    }

    @Override
    public boolean needsRedo(Transaction xact) throws StandardException {
        if (!this.removeAtOnce) {
            return false;
        }
        FileResource fr = ((RawTransaction)xact).getDataFactory().getFileHandler();
        this.fileToGo = fr.getAsFile(this.name, this.generationId);
        if (this.fileToGo == null) {
            return false;
        }
        return this.fileToGo.exists();
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.fileToGo != null) {
            BaseDataFileFactory bdff = (BaseDataFileFactory)((RawTransaction)xact).getDataFactory();
            bdff.fileToRemove(this.fileToGo, false);
        }
        return null;
    }
}

