/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.shared.common.sanity.SanityManager;

class CreateTableNode
extends DDLStatementNode {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private Properties properties;
    private TableElementList tableElementList;
    protected int tableType;
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;

    CreateTableNode(TableName tableName, TableElementList tableElementList, Properties properties, char lockGranularity, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.tableType = 0;
        this.lockGranularity = lockGranularity;
        this.implicitCreateSchema = true;
        if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
            SanityManager.THROWASSERT("Unexpected value for lockGranularity = " + this.lockGranularity);
        }
        this.tableElementList = tableElementList;
        this.properties = properties;
    }

    CreateTableNode(TableName tableName, TableElementList tableElementList, Properties properties, boolean onCommitDeleteRows, boolean onRollbackDeleteRows, ContextManager cm) throws StandardException {
        super(CreateTableNode.tempTableSchemaNameCheck(tableName), cm);
        this.tableType = 3;
        this.onCommitDeleteRows = onCommitDeleteRows;
        this.onRollbackDeleteRows = onRollbackDeleteRows;
        this.tableElementList = tableElementList;
        this.properties = properties;
        if (!this.onRollbackDeleteRows) {
            SanityManager.THROWASSERT("Unexpected value for onRollbackDeleteRows = " + this.onRollbackDeleteRows);
        }
    }

    CreateTableNode(TableName tableName, ResultColumnList resultColumns, ResultSetNode queryExpression, ContextManager cm) throws StandardException {
        super(tableName, cm);
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.resultColumns = resultColumns;
        this.queryExpression = queryExpression;
    }

    private static TableName tempTableSchemaNameCheck(TableName tableName) throws StandardException {
        if (tableName != null) {
            if (tableName.getSchemaName() == null) {
                tableName.setSchemaName("SESSION");
            } else if (!CreateTableNode.isSessionSchema(tableName.getSchemaName())) {
                throw StandardException.newException("428EK", new Object[0]);
            }
        }
        return tableName;
    }

    @Override
    public String toString() {
        String tempString = "";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: \n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: \n" + this.onRollbackDeleteRows + "\n";
        } else {
            tempString = tempString + (this.properties != null ? "properties: \n" + this.properties + "\n" : "") + "lockGranularity: " + this.lockGranularity + "\n";
        }
        return super.toString() + tempString;
    }

    @Override
    void printSubNodes(int depth) {
        this.printLabel(depth, "tableElementList: ");
        this.tableElementList.treePrint(depth + 1);
    }

    @Override
    String statementToString() {
        if (this.tableType == 3) {
            return "DECLARE GLOBAL TEMPORARY TABLE";
        }
        return "CREATE TABLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        FromList fromList;
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor sd = this.getSchemaDescriptor(this.tableType != 3, true);
        if (this.queryExpression != null) {
            fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            CompilerContext cc = this.getCompilerContext();
            ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
            ProviderList apl = new ProviderList();
            try {
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.pushCurrentPrivType(0);
                this.queryExpression = this.queryExpression.bindNonVTITables(dataDictionary, fromList);
                this.queryExpression = this.queryExpression.bindVTITables(fromList);
                this.queryExpression.bindExpressions(fromList);
                this.queryExpression.bindResultColumns(fromList);
                this.queryExpression.bindUntypedNullsToResultColumns(null);
            }
            finally {
                cc.popCurrentPrivType();
                cc.setCurrentAuxiliaryProviderList(prevAPL);
            }
            ResultColumnList qeRCL = this.queryExpression.getResultColumns();
            if (this.resultColumns != null) {
                if (this.resultColumns.size() != qeRCL.visibleSize()) {
                    throw StandardException.newException("42X70", this.getFullName());
                }
                qeRCL.copyResultColumnNames(this.resultColumns);
            }
            int schemaCollationType = sd.getCollationType();
            this.tableElementList = new TableElementList(this.getContextManager());
            for (ResultColumn rc : qeRCL) {
                if (rc.isGenerated()) continue;
                if (rc.isNameGenerated()) {
                    throw StandardException.newException("42909", new Object[0]);
                }
                DataTypeDescriptor dtd = rc.getExpression().getTypeServices();
                if (dtd != null && !dtd.isUserCreatableType()) {
                    throw StandardException.newException("42X71", dtd.getFullSQLTypeName(), rc.getName());
                }
                if (dtd.getTypeId().isStringTypeId() && dtd.getCollationType() != schemaCollationType) {
                    throw StandardException.newException("42ZA3", dtd.getCollationName(), DataTypeDescriptor.getCollationName(schemaCollationType));
                }
                ColumnDefinitionNode column = new ColumnDefinitionNode(rc.getName(), null, rc.getType(), null, this.getContextManager());
                this.tableElementList.addTableElement(column);
            }
        } else {
            this.tableElementList.setCollationTypesOnCharacterStringColumns(this.getSchemaDescriptor(this.tableType != 3, true));
        }
        this.tableElementList.validate(this, dataDictionary, null);
        if (this.tableElementList.countNumberOfColumns() > 1012) {
            throw StandardException.newException("54011", String.valueOf(this.tableElementList.countNumberOfColumns()), this.getRelativeName(), String.valueOf(1012));
        }
        int numPrimaryKeys = this.tableElementList.countConstraints(2);
        if (numPrimaryKeys > 1) {
            throw StandardException.newException("42X90", this.getRelativeName());
        }
        int numCheckConstraints = this.tableElementList.countConstraints(4);
        int numReferenceConstraints = this.tableElementList.countConstraints(6);
        int numUniqueConstraints = this.tableElementList.countConstraints(3);
        int numGenerationClauses = this.tableElementList.countGenerationClauses();
        if (this.tableType == 3 && (numPrimaryKeys > 0 || numCheckConstraints > 0 || numReferenceConstraints > 0 || numUniqueConstraints > 0)) {
            throw StandardException.newException("42995", new Object[0]);
        }
        if (numPrimaryKeys + numReferenceConstraints + numUniqueConstraints > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", String.valueOf(numPrimaryKeys + numReferenceConstraints + numUniqueConstraints), this.getRelativeName(), String.valueOf(Short.MAX_VALUE));
        }
        if (numCheckConstraints > 0 || numGenerationClauses > 0 || numReferenceConstraints > 0) {
            fromList = this.makeFromList(null, this.tableElementList, true);
            FormatableBitSet generatedColumns = new FormatableBitSet();
            if (numGenerationClauses > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(sd, fromList, generatedColumns, null);
            }
            if (numCheckConstraints > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (numReferenceConstraints > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, generatedColumns);
            }
        }
        if (numPrimaryKeys > 0) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.getSchemaDescriptor(this.tableType != 3, true));
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        TableElementList coldefs = this.tableElementList;
        ColumnInfo[] colInfos = new ColumnInfo[coldefs.countNumberOfColumns()];
        int numConstraints = coldefs.genColumnInfos(colInfos);
        ConstraintConstantAction[] conActions = null;
        SchemaDescriptor sd = this.getSchemaDescriptor(this.tableType != 3, true);
        if (numConstraints > 0) {
            conActions = new CreateConstraintConstantAction[numConstraints];
            coldefs.genConstraintActions(true, conActions, this.getRelativeName(), sd, this.getDataDictionary());
        }
        boolean table_has_long_column = false;
        int approxLength = 0;
        for (int i = 0; i < colInfos.length; ++i) {
            DataTypeDescriptor dts = colInfos[i].getDataType();
            if (dts.getTypeId().isLongConcatableTypeId()) {
                table_has_long_column = true;
                break;
            }
            approxLength += dts.getTypeId().getApproximateLengthInBytes(dts);
        }
        if (!(!table_has_long_column && approxLength <= 4096 || this.properties != null && this.properties.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null)) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateTableConstantAction(sd.getSchemaName(), this.getRelativeName(), this.tableType, colInfos, (CreateConstraintConstantAction[])conActions, this.properties, this.lockGranularity, this.onCommitDeleteRows, this.onRollbackDeleteRows);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableElementList != null) {
            this.tableElementList.accept(v);
        }
    }
}

