/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.Serializable;
import org.apache.daffodil.api.metadata.MetadataHandler;
import org.apache.daffodil.api.metadata.SequenceMetadata;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.processors.ChoiceRuntimeData;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.ErrorERD;
import org.apache.daffodil.runtime1.processors.ModelGroupRuntimeData;
import org.apache.daffodil.runtime1.processors.SequenceRuntimeData;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import scala.Function1;
import scala.MatchError;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class MetadataWalker {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MetadataWalker.class.getDeclaredField("rootERD$lzy1"));
    private final DataProcessor dp;
    private volatile Object rootERD$lzy1;

    public MetadataWalker(DataProcessor dp) {
        this.dp = dp;
    }

    private DataProcessor dp() {
        return this.dp;
    }

    private ElementRuntimeData rootERD() {
        Object object = this.rootERD$lzy1;
        if (object instanceof ElementRuntimeData) {
            return (ElementRuntimeData)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ElementRuntimeData)this.rootERD$lzyINIT1();
    }

    private Object rootERD$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.rootERD$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ElementRuntimeData elementRuntimeData = null;
                    try {
                        elementRuntimeData = this.dp().ssrd().elementRuntimeData();
                        object2 = elementRuntimeData == null ? LazyVals.NullValue$.MODULE$ : elementRuntimeData;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.rootERD$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return elementRuntimeData;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void walk(MetadataHandler handler) {
        this.walkTerm(handler, this.rootERD());
    }

    private void walkTerm(MetadataHandler handler, TermRuntimeData trd) {
        TermRuntimeData termRuntimeData = trd;
        if (termRuntimeData instanceof ErrorERD) {
            ErrorERD err = (ErrorERD)termRuntimeData;
            throw Assert$.MODULE$.invariantFailed("should not get ErrorERDs");
        }
        if (termRuntimeData instanceof ElementRuntimeData) {
            ElementRuntimeData erd = (ElementRuntimeData)termRuntimeData;
            this.walkElement(handler, erd);
            return;
        }
        if (termRuntimeData instanceof SequenceRuntimeData) {
            SequenceRuntimeData srd = (SequenceRuntimeData)termRuntimeData;
            this.walkSequence(handler, srd);
            return;
        }
        if (termRuntimeData instanceof ChoiceRuntimeData) {
            ChoiceRuntimeData crd = (ChoiceRuntimeData)termRuntimeData;
            this.walkChoice(handler, crd);
            return;
        }
        throw new MatchError((Object)termRuntimeData);
    }

    private void walkElement(MetadataHandler handler, ElementRuntimeData erd) {
        if (erd.optComplexTypeModelGroupRuntimeData().isDefined()) {
            this.walkComplexElement(handler, erd);
            return;
        }
        this.walkSimpleElement(handler, erd);
    }

    private void walkComplexElement(MetadataHandler handler, ElementRuntimeData erd) {
        ModelGroupRuntimeData mgrd = (ModelGroupRuntimeData)erd.optComplexTypeModelGroupRuntimeData().getOrElse(MetadataWalker::$anonfun$1);
        handler.startComplexElementMetadata(erd);
        this.walkTerm(handler, mgrd);
        handler.endComplexElementMetadata(erd);
    }

    private void walkSimpleElement(MetadataHandler handler, ElementRuntimeData erd) {
        handler.simpleElementMetadata(erd);
    }

    private void walkSequence(MetadataHandler handler, SequenceMetadata sm) {
        SequenceRuntimeData srd = (SequenceRuntimeData)sm;
        if (!srd.isHidden()) {
            handler.startSequenceMetadata(srd);
            srd.groupMembers().map((Function1)(JProcedure1 & Serializable)trd -> this.walkTerm(handler, (TermRuntimeData)trd));
            handler.endSequenceMetadata(srd);
            return;
        }
    }

    private void walkChoice(MetadataHandler handler, ChoiceRuntimeData crd) {
        handler.startChoiceMetadata(crd);
        crd.groupMembers().map((Function1)(JProcedure1 & Serializable)trd -> this.walkTerm(handler, (TermRuntimeData)trd));
        handler.endChoiceMetadata(crd);
    }

    private static final ModelGroupRuntimeData $anonfun$1() {
        throw Assert$.MODULE$.invariantFailed("not a complex type element");
    }
}

