/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.cursor.impl.BasePagingCounter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSubscriptionCounterImpl
extends BasePagingCounter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final long subscriptionID;
    private long recordID = -1L;
    private volatile long recordedValue = -1L;
    private static final AtomicLongFieldUpdater<PageSubscriptionCounterImpl> recordedValueUpdater = AtomicLongFieldUpdater.newUpdater(PageSubscriptionCounterImpl.class, "recordedValue");
    private volatile long recordedSize = -1L;
    private static final AtomicLongFieldUpdater<PageSubscriptionCounterImpl> recordedSizeUpdater = AtomicLongFieldUpdater.newUpdater(PageSubscriptionCounterImpl.class, "recordedSize");
    private PageSubscription subscription;
    private PagingStore pagingStore;
    private final StorageManager storage;
    private volatile long value;
    private static final AtomicLongFieldUpdater<PageSubscriptionCounterImpl> valueUpdater = AtomicLongFieldUpdater.newUpdater(PageSubscriptionCounterImpl.class, "value");
    private volatile long persistentSize;
    private static final AtomicLongFieldUpdater<PageSubscriptionCounterImpl> persistentSizeUpdater = AtomicLongFieldUpdater.newUpdater(PageSubscriptionCounterImpl.class, "persistentSize");
    private volatile long added;
    private static final AtomicLongFieldUpdater<PageSubscriptionCounterImpl> addedUpdater = AtomicLongFieldUpdater.newUpdater(PageSubscriptionCounterImpl.class, "added");
    private volatile long addedPersistentSize;
    private static final AtomicLongFieldUpdater<PageSubscriptionCounterImpl> addedPersistentSizeUpdater = AtomicLongFieldUpdater.newUpdater(PageSubscriptionCounterImpl.class, "addedPersistentSize");
    private LinkedList<PendingCounter> loadList;

    public PageSubscriptionCounterImpl(StorageManager storage, long subscriptionID) {
        this.subscriptionID = subscriptionID;
        this.storage = storage;
    }

    @Override
    public void markRebuilding() {
        if (logger.isDebugEnabled()) {
            logger.debug("Subscription {} marked for rebuilding", (Object)this.subscriptionID);
        }
        super.markRebuilding();
        recordedSizeUpdater.set(this, persistentSizeUpdater.get(this));
        recordedValueUpdater.set(this, recordedValueUpdater.get(this));
        try {
            this.reset();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void finishRebuild() {
        super.finishRebuild();
        if (logger.isDebugEnabled()) {
            logger.debug("Subscription {} finished rebuilding", (Object)this.subscriptionID);
        }
        this.snapshot();
        addedUpdater.set(this, valueUpdater.get(this));
        addedPersistentSizeUpdater.set(this, persistentSizeUpdater.get(this));
    }

    @Override
    public long getValueAdded() {
        return addedUpdater.get(this);
    }

    @Override
    public long getValue() {
        if (this.isRebuilding()) {
            if (logger.isTraceEnabled()) {
                logger.trace("returning getValue from isPending on subscription {}, recordedValue={}, addedUpdater={}", (Object)recordedValueUpdater.get(this), (Object)addedUpdater.get(this));
            }
            return recordedValueUpdater.get(this);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("returning regular getValue subscription {}, value={}", (Object)this.subscriptionID, (Object)valueUpdater.get(this));
        }
        return valueUpdater.get(this);
    }

    @Override
    public long getPersistentSizeAdded() {
        return addedPersistentSizeUpdater.get(this);
    }

    @Override
    public long getPersistentSize() {
        if (this.isRebuilding()) {
            if (logger.isTraceEnabled()) {
                logger.trace("returning getPersistentSize from isPending on subscription {}, recordedSize={}. addedSize={}", new Object[]{this.subscriptionID, recordedSizeUpdater.get(this), addedPersistentSizeUpdater.get(this)});
            }
            return recordedSizeUpdater.get(this);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("returning regular getPersistentSize subscription {}, value={}", (Object)this.subscriptionID, (Object)persistentSizeUpdater.get(this));
        }
        return persistentSizeUpdater.get(this);
    }

    @Override
    public void increment(Transaction tx, int add, long size) throws Exception {
        if (tx == null) {
            this.process(add, size);
        } else {
            this.applyIncrementOnTX(tx, add, size);
        }
    }

    @Override
    public void applyIncrementOnTX(Transaction tx, int add, long size) {
        CounterOperations oper = (CounterOperations)tx.getProperty(3);
        if (oper == null) {
            oper = new CounterOperations();
            tx.putProperty(3, oper);
            tx.addOperation(oper);
        }
        oper.operations.add(new ItemOper(this, add, size));
    }

    @Override
    public synchronized void loadValue(long recordID, long value, long size) {
        if (logger.isDebugEnabled()) {
            logger.debug("Counter for subscription {} reloading recordID={}, value={}, size={}", new Object[]{this.subscriptionID, recordID, value, size});
        }
        this.recordID = recordID;
        recordedValueUpdater.set(this, value);
        recordedSizeUpdater.set(this, size);
        valueUpdater.set(this, value);
        persistentSizeUpdater.set(this, size);
        addedUpdater.set(this, size);
    }

    private void process(int add, long size) {
        if (logger.isTraceEnabled()) {
            logger.trace("process subscription={} add={}, size={}", new Object[]{this.subscriptionID, add, size});
        }
        long value = valueUpdater.addAndGet(this, add);
        persistentSizeUpdater.addAndGet(this, size);
        if (add > 0) {
            addedUpdater.addAndGet(this, add);
            addedPersistentSizeUpdater.addAndGet(this, size);
            if (this.pagingStore != null && this.pagingStore.getPageFullMessagePolicy() != null && !this.pagingStore.isPageFull()) {
                this.checkAdd(value);
            }
        }
        if (this.isRebuilding()) {
            recordedValueUpdater.addAndGet(this, value);
            recordedSizeUpdater.addAndGet(this, size);
        }
    }

    private void checkAdd(long numberOfMessages) {
        Long pageLimitMessages = this.pagingStore.getPageLimitMessages();
        if (pageLimitMessages != null && numberOfMessages >= pageLimitMessages) {
            this.pagingStore.pageFull(this.subscription);
        }
    }

    @Override
    public void delete() throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storage);
        this.delete(tx);
        tx.commit();
    }

    void reset() throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storage);
        this.delete(tx, true);
        tx.commit();
    }

    @Override
    public void delete(Transaction tx) throws Exception {
        this.delete(tx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(Transaction tx, boolean keepZero) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Subscription {} delete, keepZero={}", (Object)this.subscriptionID, (Object)keepZero);
        }
        try (ArtemisCloseable lock = this.storage.closeableReadLock();){
            PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
            synchronized (pageSubscriptionCounterImpl) {
                if (this.recordID >= 0L) {
                    this.storage.deletePageCounter(tx.getID(), this.recordID);
                    tx.setContainsPersistent();
                }
                if (keepZero) {
                    tx.setContainsPersistent();
                    this.recordID = this.storage.storePageCounter(tx.getID(), this.subscriptionID, 0L, 0L);
                } else {
                    this.recordID = -1L;
                }
                valueUpdater.set(this, 0L);
                persistentSizeUpdater.set(this, 0L);
            }
        }
    }

    @Override
    public void loadInc(long id, int add, long size) {
        if (this.loadList == null) {
            this.loadList = new LinkedList();
        }
        this.loadList.add(new PendingCounter(id, add, size));
    }

    @Override
    public void processReload() {
        if (this.loadList != null) {
            try {
                long tx = -1L;
                logger.debug("Removing increment records on cursor {}", (Object)this.subscriptionID);
                for (PendingCounter incElement : this.loadList) {
                    if (tx < 0L) {
                        tx = this.storage.generateID();
                    }
                    this.storage.deletePageCounter(tx, incElement.id);
                }
                if (tx >= 0L) {
                    this.storage.commit(tx);
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            this.loadList.clear();
            this.loadList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void snapshot() {
        if (this.isRebuilding()) {
            if (logger.isDebugEnabled()) {
                logger.debug("snapshot call ignored as cursor is being rebuilt for {}", (Object)this.subscriptionID);
            }
            return;
        }
        if (!this.storage.isStarted()) {
            logger.debug("Storage is not active, ignoring snapshot call on {}", (Object)this.subscriptionID);
            return;
        }
        long valueReplace = valueUpdater.get(this);
        long sizeReplace = persistentSizeUpdater.get(this);
        long newRecordID = -1L;
        long txCleanup = -1L;
        try {
            if (this.recordID >= 0L) {
                if (txCleanup < 0L) {
                    txCleanup = this.storage.generateID();
                }
                this.storage.deletePageCounter(txCleanup, this.recordID);
                this.recordID = -1L;
            }
            if (valueReplace > 0L) {
                if (txCleanup < 0L) {
                    txCleanup = this.storage.generateID();
                }
                newRecordID = this.storage.storePageCounter(txCleanup, this.subscriptionID, valueReplace, sizeReplace);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Replacing page-counter record = {} by record = {} on subscriptionID = {} for queue = {}, value = {}, size = {}", new Object[]{this.recordID, newRecordID, this.subscriptionID, this.subscription.getQueue().getName(), valueReplace, sizeReplace});
            }
            if (txCleanup >= 0L) {
                this.storage.commit(txCleanup);
            }
        }
        catch (Exception e) {
            newRecordID = this.recordID;
            ActiveMQServerLogger.LOGGER.problemCleaningPagesubscriptionCounter(e);
            if (txCleanup >= 0L) {
                try {
                    this.storage.rollback(txCleanup);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.recordID = newRecordID;
            recordedValueUpdater.set(this, valueReplace);
            recordedSizeUpdater.set(this, sizeReplace);
        }
    }

    @Override
    public PageSubscriptionCounter setSubscription(PageSubscription subscription) {
        this.subscription = subscription;
        this.pagingStore = subscription.getPagingStore();
        return this;
    }

    private static class PendingCounter {
        private static final AtomicIntegerFieldUpdater<PendingCounter> COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PendingCounter.class, "count");
        private static final AtomicLongFieldUpdater<PendingCounter> SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(PendingCounter.class, "persistentSize");
        private final long id;
        private volatile int count;
        private volatile long persistentSize;

        PendingCounter(long id, int count, long persistentSize) {
            this.id = id;
            this.count = count;
            this.persistentSize = persistentSize;
        }

        public long getId() {
            return this.id;
        }

        public int getCount() {
            return this.count;
        }

        public long getPersistentSize() {
            return this.persistentSize;
        }

        public void addAndGet(int count, long persistentSize) {
            COUNT_UPDATER.addAndGet(this, count);
            SIZE_UPDATER.addAndGet(this, persistentSize);
        }
    }

    private static class CounterOperations
    extends TransactionOperationAbstract
    implements TransactionOperation {
        LinkedList<ItemOper> operations = new LinkedList();

        private CounterOperations() {
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (ItemOper oper : this.operations) {
                oper.counter.process(oper.amount, oper.persistentSize);
            }
        }
    }

    private static class ItemOper {
        PageSubscriptionCounterImpl counter;
        int amount;
        long persistentSize;

        private ItemOper(PageSubscriptionCounterImpl counter, int add, long persistentSize) {
            this.counter = counter;
            this.amount = add;
            this.persistentSize = persistentSize;
        }
    }
}

