/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Const;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.tools.corba.processors.idl.FixedPtConstVisitor;
import org.apache.cxf.tools.corba.processors.idl.PrimitiveTypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopedNameVisitor;
import org.apache.cxf.tools.corba.processors.idl.StringVisitor;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.Visitor;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaType;

public class ConstVisitor
extends VisitorBase {
    public ConstVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor) {
        super(scope, defn, schemaRef, wsdlVisitor);
    }

    public static boolean accept(AST node) {
        return node.getType() == 26;
    }

    @Override
    public void visit(AST constNode) {
        byte ch;
        AST constTypeNode = constNode.getFirstChild();
        AST constNameNode = TypesUtils.getCorbaTypeNameNode(constTypeNode);
        AST constValueNode = constNameNode.getNextSibling();
        StringBuilder constValue = new StringBuilder();
        if (constValueNode.toString() != null) {
            constValue.append(constValueNode.toString());
        }
        constValueNode = constValueNode.getFirstChild();
        if (constValue.length() == 1 && (ch = (byte)constValue.charAt(0)) >= 0 && ch <= 31) {
            constValue.deleteCharAt(0);
            constValue.append('\\').append(Integer.toOctalString(ch));
        }
        while (constValueNode != null) {
            constValue.append(constValueNode.toString());
            constValueNode = constValueNode.getFirstChild();
        }
        QName constQName = new QName(this.typeMap.getTargetNamespace(), new Scope(this.getScope(), constNameNode).toString());
        Visitor visitor = null;
        if (PrimitiveTypesVisitor.accept(constTypeNode)) {
            visitor = new PrimitiveTypesVisitor(this.getScope(), this.definition, this.schema, this.schemas);
        } else if (StringVisitor.accept(constTypeNode)) {
            visitor = new StringVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor, constTypeNode);
        } else if (FixedPtConstVisitor.accept(constTypeNode)) {
            visitor = new FixedPtConstVisitor(this.getScope(), this.definition, this.schema, this.schemas);
        } else if (ScopedNameVisitor.accept(this.getScope(), this.definition, this.schema, constTypeNode, this.wsdlVisitor)) {
            visitor = new ScopedNameVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
        }
        if (visitor == null) {
            throw new RuntimeException("can't resolve type for const " + constNameNode.getText());
        }
        visitor.visit(constTypeNode);
        XmlSchemaType constSchemaType = visitor.getSchemaType();
        CorbaType constCorbaType = visitor.getCorbaType();
        Const corbaConst = new Const();
        corbaConst.setQName(constQName);
        corbaConst.setValue(constValue.toString());
        corbaConst.setType(constSchemaType.getQName());
        corbaConst.setIdltype(constCorbaType.getQName());
        this.typeMap.getStructOrExceptionOrUnion().add(corbaConst);
    }
}

