/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.event.map;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.event.map.KEYS;
import org.apache.cxf.sts.event.map.MapEvent;
import org.apache.cxf.sts.event.map.MapEventListener;

public class MapEventLogger
implements MapEventListener {
    private static final Logger LOG = LogUtils.getL7dLogger(MapEventLogger.class);
    private List<String> fieldOrder = Arrays.asList(KEYS.TIME.name(), KEYS.STATUS.name(), KEYS.DURATION.name(), KEYS.REMOTE_HOST.name(), KEYS.REMOTE_PORT.name(), KEYS.OPERATION.name(), KEYS.URL.name(), KEYS.REALM.name(), KEYS.WS_SEC_PRINCIPAL.name(), KEYS.ONBEHALFOF_PRINCIPAL.name(), KEYS.ACTAS_PRINCIPAL.name(), KEYS.VALIDATE_PRINCIPAL.name(), KEYS.CANCEL_PRINCIPAL.name(), KEYS.RENEW_PRINCIPAL.name(), KEYS.TOKENTYPE.name(), KEYS.KEYTYPE.name(), KEYS.APPLIESTO.name(), KEYS.CLAIMS_PRIMARY.name(), KEYS.CLAIMS_SECONDARY.name(), KEYS.EXCEPTION.name(), KEYS.STACKTRACE.name());
    private boolean logStacktrace;
    private boolean logFieldname;
    private Level logLevel = Level.FINE;
    private String format;

    @Override
    public void onEvent(MapEvent event) {
        Map<String, ?> map = event.getProperties();
        StringBuilder builder = new StringBuilder();
        for (String key : this.fieldOrder) {
            if (this.logFieldname) {
                builder.append(key).append('=').append(map.get(key)).append(';');
                continue;
            }
            builder.append(this.format(map.get(key))).append(';');
        }
        Exception ex = (Exception)map.get(KEYS.EXCEPTION.name());
        if (this.logStacktrace) {
            LOG.log(this.logLevel, builder.toString(), ex);
        } else {
            LOG.log(this.logLevel, builder.toString());
        }
    }

    private String format(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            DateFormat dateFormat = this.format != null ? new SimpleDateFormat(this.format) : DateFormat.getDateTimeInstance(3, 2);
            return dateFormat.format(value);
        }
        return value == null ? "<null>" : value.toString();
    }

    public List<String> getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(List<String> fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public boolean isLogStacktrace() {
        return this.logStacktrace;
    }

    public void setLogStacktrace(boolean logStacktrace) {
        this.logStacktrace = logStacktrace;
    }

    public boolean isLogFieldname() {
        return this.logFieldname;
    }

    public void setLogFieldname(boolean logFieldname) {
        this.logFieldname = logFieldname;
    }

    public void setDateFormat(String dateFormat) {
        this.format = dateFormat;
    }

    public String getLogLevel() {
        return this.logLevel.getName();
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = Level.parse(logLevel);
    }
}

