/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.net.URI;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;

public class CXFHttpRequest
extends AbstractHttpMessage
implements HttpEntityEnclosingRequest,
Configurable {
    private final String method;
    private URI uri;
    private HttpEntity entity;
    private AsyncHTTPConduit.AsyncWrappedOutputStream out;
    private RequestConfig config;

    public CXFHttpRequest(String method) {
        this.method = method;
    }

    public void setOutputStream(AsyncHTTPConduit.AsyncWrappedOutputStream o) {
        this.out = o;
    }

    public AsyncHTTPConduit.AsyncWrappedOutputStream getOutputStream() {
        return this.out;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI u) {
        this.uri = u;
    }

    public String getMethod() {
        return this.method;
    }

    public RequestLine getRequestLine() {
        return new BasicRequestLine(this.method, this.uri != null ? this.uri.toASCIIString() : "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
    }

    public ProtocolVersion getProtocolVersion() {
        return HttpVersion.HTTP_1_1;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public boolean expectContinue() {
        Header expect = this.getFirstHeader("Expect");
        return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }
}

