/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileData;
import org.apache.commons.vfs2.provider.ram.RamFileOutputStream;
import org.apache.commons.vfs2.provider.ram.RamFileRandomAccessContent;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;
import org.apache.commons.vfs2.provider.ram.RamFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class RamFileObject
extends AbstractFileObject<RamFileSystem> {
    private RamFileData data;

    protected RamFileObject(AbstractFileName fileName, RamFileSystem fileSystem) {
        super(fileName, fileSystem);
        ((RamFileSystem)this.getAbstractFileSystem()).attach(this);
    }

    @Override
    protected void doAttach() throws Exception {
        ((RamFileSystem)this.getAbstractFileSystem()).attach(this);
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.injectType(FileType.FOLDER);
        this.save();
    }

    @Override
    protected void doDelete() throws Exception {
        if (this.isContentOpen()) {
            throw new FileSystemException(this.getName() + " cannot be deleted while the file is open");
        }
        ((RamFileSystem)this.getAbstractFileSystem()).delete(this);
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.size();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        return new ByteArrayInputStream(this.data.getContent());
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.data.getLastModified();
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (!bAppend) {
            this.data.setContent(ArrayUtils.EMPTY_BYTE_ARRAY);
        }
        return new RamFileOutputStream(this);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new RamFileRandomAccessContent(this, mode);
    }

    @Override
    protected FileType doGetType() throws Exception {
        return this.data.getType();
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return ((RamFileSystem)this.getAbstractFileSystem()).listChildren(this.getName());
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        RamFileObject newRamFileObject = (RamFileObject)FileObjectUtils.getAbstractFileObject(newFile);
        ((RamFileSystem)this.getAbstractFileSystem()).rename(this, newRamFileObject);
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.data.setLastModified(modtime);
        return true;
    }

    @Override
    protected void endOutput() throws Exception {
        super.endOutput();
        this.save();
    }

    RamFileData getData() {
        return this.data;
    }

    @Override
    protected void injectType(FileType fileType) {
        this.data.setType(fileType);
        super.injectType(fileType);
    }

    synchronized void resize(long newSize) throws IOException {
        RamFileSystem afs = (RamFileSystem)this.getAbstractFileSystem();
        FileSystemOptions afsOptions = afs.getFileSystemOptions();
        if (afsOptions != null) {
            long maxSize = RamFileSystemConfigBuilder.getInstance().getLongMaxSize(afsOptions);
            if (afs.size() + newSize - (long)this.size() > maxSize) {
                throw new IOException("FileSystem capacity (" + maxSize + ") exceeded.");
            }
        }
        this.data.resize(newSize);
    }

    private void save() throws FileSystemException {
        ((RamFileSystem)this.getAbstractFileSystem()).save(this);
    }

    void setData(RamFileData data) {
        this.data = data;
    }

    int size() {
        return this.data == null ? 0 : this.data.size();
    }
}

