/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import org.apache.commons.math3.analysis.polynomials.PolynomialFunctionLagrangeForm;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.junit.Assert;
import org.junit.Test;

public final class PolynomialFunctionLagrangeFormTest {
    @Test
    public void testLinearFunction() {
        double tolerance = 1.0E-12;
        double[] x = new double[]{0.0, 3.0};
        double[] y = new double[]{-4.0, 0.5};
        PolynomialFunctionLagrangeForm p = new PolynomialFunctionLagrangeForm(x, y);
        double z = 2.0;
        double expected = -1.0;
        double result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 4.5;
        expected = 2.75;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 6.0;
        expected = 5.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        Assert.assertEquals((long)1L, (long)p.degree());
        double[] c = p.getCoefficients();
        Assert.assertEquals((long)2L, (long)c.length);
        Assert.assertEquals((double)-4.0, (double)c[0], (double)tolerance);
        Assert.assertEquals((double)1.5, (double)c[1], (double)tolerance);
    }

    @Test
    public void testQuadraticFunction() {
        double tolerance = 1.0E-12;
        double[] x = new double[]{0.0, -1.0, 0.5};
        double[] y = new double[]{-3.0, -6.0, 0.0};
        PolynomialFunctionLagrangeForm p = new PolynomialFunctionLagrangeForm(x, y);
        double z = 1.0;
        double expected = 4.0;
        double result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 2.5;
        expected = 22.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = -2.0;
        expected = -5.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        Assert.assertEquals((long)2L, (long)p.degree());
        double[] c = p.getCoefficients();
        Assert.assertEquals((long)3L, (long)c.length);
        Assert.assertEquals((double)-3.0, (double)c[0], (double)tolerance);
        Assert.assertEquals((double)5.0, (double)c[1], (double)tolerance);
        Assert.assertEquals((double)2.0, (double)c[2], (double)tolerance);
    }

    @Test
    public void testQuinticFunction() {
        double tolerance = 1.0E-12;
        double[] x = new double[]{1.0, -1.0, 2.0, 3.0, -3.0, 0.5};
        double[] y = new double[]{0.0, 0.0, -24.0, 0.0, -144.0, 2.34375};
        PolynomialFunctionLagrangeForm p = new PolynomialFunctionLagrangeForm(x, y);
        double z = 0.0;
        double expected = 0.0;
        double result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = -2.0;
        expected = 0.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 4.0;
        expected = 360.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        Assert.assertEquals((long)5L, (long)p.degree());
        double[] c = p.getCoefficients();
        Assert.assertEquals((long)6L, (long)c.length);
        Assert.assertEquals((double)0.0, (double)c[0], (double)tolerance);
        Assert.assertEquals((double)6.0, (double)c[1], (double)tolerance);
        Assert.assertEquals((double)1.0, (double)c[2], (double)tolerance);
        Assert.assertEquals((double)-7.0, (double)c[3], (double)tolerance);
        Assert.assertEquals((double)-1.0, (double)c[4], (double)tolerance);
        Assert.assertEquals((double)1.0, (double)c[5], (double)tolerance);
    }

    @Test
    public void testParameters() {
        double[] y;
        double[] x2;
        try {
            x2 = new double[]{1.0};
            y = new double[]{2.0};
            new PolynomialFunctionLagrangeForm(x2, y);
            Assert.fail((String)"Expecting MathIllegalArgumentException - bad input array length");
        }
        catch (MathIllegalArgumentException x2) {
            // empty catch block
        }
        try {
            x2 = new double[]{1.0, 2.0, 3.0, 4.0};
            y = new double[]{0.0, -4.0, -24.0};
            new PolynomialFunctionLagrangeForm(x2, y);
            Assert.fail((String)"Expecting MathIllegalArgumentException - mismatch input arrays");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

