/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.SumSincFunction;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.PowellOptimizer;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class PowellOptimizerTest {
    @Test
    public void testSumSinc() {
        int i;
        SumSincFunction func = new SumSincFunction(-1.0);
        int dim = 2;
        double[] minPoint = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            minPoint[i2] = 0.0;
        }
        double[] init = new double[dim];
        for (i = 0; i < dim; ++i) {
            init[i] = minPoint[i];
        }
        this.doTest(func, minPoint, init, GoalType.MINIMIZE, 1.0E-9, 1.0E-9);
        for (i = 0; i < dim; ++i) {
            init[i] = minPoint[i] + 3.0;
        }
        this.doTest(func, minPoint, init, GoalType.MINIMIZE, 1.0E-9, 1.0E-5);
        this.doTest(func, minPoint, init, GoalType.MINIMIZE, 1.0E-9, 1.0E-9, 1.0E-7);
    }

    @Test
    public void testQuadratic() {
        int i;
        MultivariateFunction func = new MultivariateFunction(){

            public double value(double[] x) {
                double a = x[0] - 1.0;
                double b = x[1] - 1.0;
                return a * a + b * b + 1.0;
            }
        };
        int dim = 2;
        double[] minPoint = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            minPoint[i2] = 1.0;
        }
        double[] init = new double[dim];
        for (i = 0; i < dim; ++i) {
            init[i] = minPoint[i];
        }
        this.doTest(func, minPoint, init, GoalType.MINIMIZE, 1.0E-9, 1.0E-8);
        for (i = 0; i < dim; ++i) {
            init[i] = minPoint[i] - 20.0;
        }
        this.doTest(func, minPoint, init, GoalType.MINIMIZE, 1.0E-9, 1.0E-8);
    }

    @Test
    public void testMaximizeQuadratic() {
        int i;
        MultivariateFunction func = new MultivariateFunction(){

            public double value(double[] x) {
                double a = x[0] - 1.0;
                double b = x[1] - 1.0;
                return -a * a - b * b + 1.0;
            }
        };
        int dim = 2;
        double[] maxPoint = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            maxPoint[i2] = 1.0;
        }
        double[] init = new double[dim];
        for (i = 0; i < dim; ++i) {
            init[i] = maxPoint[i];
        }
        this.doTest(func, maxPoint, init, GoalType.MAXIMIZE, 1.0E-9, 1.0E-8);
        for (i = 0; i < dim; ++i) {
            init[i] = maxPoint[i] - 20.0;
        }
        this.doTest(func, maxPoint, init, GoalType.MAXIMIZE, 1.0E-9, 1.0E-8);
    }

    @Test
    public void testRelativeToleranceOnScaledValues() {
        final MultivariateFunction func = new MultivariateFunction(){

            public double value(double[] x) {
                double a = x[0] - 1.0;
                double b = x[1] - 1.0;
                return a * a * FastMath.sqrt((double)FastMath.abs((double)a)) + b * b + 1.0;
            }
        };
        int dim = 2;
        double[] minPoint = new double[dim];
        for (int i = 0; i < dim; ++i) {
            minPoint[i] = 1.0;
        }
        double[] init = new double[dim];
        for (int i = 0; i < dim; ++i) {
            init[i] = minPoint[i] - 20.0;
        }
        double relTol = 1.0E-10;
        int maxEval = 1000;
        PowellOptimizer optim = new PowellOptimizer(1.0E-10, 1.0E-100);
        PointValuePair funcResult = optim.optimize(1000, func, GoalType.MINIMIZE, init);
        double funcValue = func.value(funcResult.getPoint());
        int funcEvaluations = optim.getEvaluations();
        double scale = 1.0E10;
        MultivariateFunction funcScaled = new MultivariateFunction(){

            public double value(double[] x) {
                return 1.0E10 * func.value(x);
            }
        };
        PointValuePair funcScaledResult = optim.optimize(1000, funcScaled, GoalType.MINIMIZE, init);
        double funcScaledValue = funcScaled.value(funcScaledResult.getPoint());
        int funcScaledEvaluations = optim.getEvaluations();
        Assert.assertEquals((double)1.0, (double)(funcScaledValue / (1.0E10 * funcValue)), (double)1.0E-10);
        Assert.assertEquals((long)funcEvaluations, (long)funcScaledEvaluations);
    }

    private void doTest(MultivariateFunction func, double[] optimum, double[] init, GoalType goal, double fTol, double pointTol) {
        PowellOptimizer optim = new PowellOptimizer(fTol, Math.ulp(1.0));
        PointValuePair result = optim.optimize(1000, func, goal, init);
        double[] point = result.getPoint();
        int dim = optimum.length;
        for (int i = 0; i < dim; ++i) {
            Assert.assertEquals((String)("found[" + i + "]=" + point[i] + " value=" + result.getValue()), (double)optimum[i], (double)point[i], (double)pointTol);
        }
    }

    private void doTest(MultivariateFunction func, double[] optimum, double[] init, GoalType goal, double fTol, double fLineTol, double pointTol) {
        PowellOptimizer optim = new PowellOptimizer(fTol, Math.ulp(1.0), fLineTol, Math.ulp(1.0));
        PointValuePair result = optim.optimize(1000, func, goal, init);
        double[] point = result.getPoint();
        int dim = optimum.length;
        for (int i = 0; i < dim; ++i) {
            Assert.assertEquals((String)("found[" + i + "]=" + point[i] + " value=" + result.getValue()), (double)optimum[i], (double)point[i], (double)pointTol);
        }
    }
}

