/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.ODEIntegrator;
import org.apache.commons.math3.ode.TestProblem1;
import org.apache.commons.math3.ode.TestProblem5;
import org.apache.commons.math3.ode.TestProblem6;
import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.ode.TestProblemHandler;
import org.apache.commons.math3.ode.nonstiff.AdamsMoultonIntegrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class AdamsMoultonIntegratorTest {
    @Test(expected=DimensionMismatchException.class)
    public void dimensionCheck() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        AdamsMoultonIntegrator integ = new AdamsMoultonIntegrator(2, 0.0, 1.0, 1.0E-10, 1.0E-10);
        integ.integrate((FirstOrderDifferentialEquations)pb, 0.0, new double[pb.getDimension() + 10], 1.0, new double[pb.getDimension() + 10]);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testMinStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double minStep = 0.1 * (pb.getFinalTime() - pb.getInitialTime());
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double[] vecAbsoluteTolerance = new double[]{1.0E-15, 1.0E-16};
        double[] vecRelativeTolerance = new double[]{1.0E-15, 1.0E-16};
        AdamsMoultonIntegrator integ = new AdamsMoultonIntegrator(4, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }

    @Test
    public void testIncreasingTolerance() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int previousCalls = Integer.MAX_VALUE;
        for (int i = -12; i < -2; ++i) {
            TestProblem1 pb = new TestProblem1();
            double minStep = 0.0;
            double maxStep = pb.getFinalTime() - pb.getInitialTime();
            double scalAbsoluteTolerance = FastMath.pow((double)10.0, (int)i);
            double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
            AdamsMoultonIntegrator integ = new AdamsMoultonIntegrator(4, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
            TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
            integ.addStepHandler((StepHandler)handler);
            integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            Assert.assertTrue((handler.getMaximalValueError() > 0.45 * scalAbsoluteTolerance ? 1 : 0) != 0);
            Assert.assertTrue((handler.getMaximalValueError() < 8.69 * scalAbsoluteTolerance ? 1 : 0) != 0);
            Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-16);
            int calls = pb.getCalls();
            Assert.assertEquals((long)integ.getEvaluations(), (long)calls);
            Assert.assertTrue((calls <= previousCalls ? 1 : 0) != 0);
            previousCalls = calls;
        }
    }

    @Test(expected=MaxCountExceededException.class)
    public void exceedMaxEvaluations() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double range = pb.getFinalTime() - pb.getInitialTime();
        AdamsMoultonIntegrator integ = new AdamsMoultonIntegrator(2, 0.0, range, 1.0E-12, 1.0E-12);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.setMaxEvaluations(650);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }

    @Test
    public void backward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double range = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime()));
        AdamsMoultonIntegrator integ = new AdamsMoultonIntegrator(4, 0.0, range, 1.0E-12, 1.0E-12);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 3.0E-9 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 3.0E-9 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-16);
        Assert.assertEquals((Object)"Adams-Moulton", (Object)integ.getName());
    }

    @Test
    public void polynomial() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem6 pb = new TestProblem6();
        double range = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime()));
        for (int nSteps = 2; nSteps < 8; ++nSteps) {
            AdamsMoultonIntegrator integ = new AdamsMoultonIntegrator(nSteps, 1.0E-6 * range, 0.1 * range, 1.0E-5, 1.0E-5);
            integ.setStarterIntegrator((FirstOrderIntegrator)new PerfectStarter(pb, nSteps));
            TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
            integ.addStepHandler((StepHandler)handler);
            integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            if (nSteps < 5) {
                Assert.assertTrue((handler.getMaximalValueError() > 2.2E-5 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((handler.getMaximalValueError() < 1.1E-11 ? 1 : 0) != 0);
        }
    }

    private static class PerfectInterpolator
    implements StepInterpolator {
        private final TestProblemAbstract problem;
        private double previousTime;
        private double currentTime;
        private double interpolatedTime;

        public PerfectInterpolator(TestProblemAbstract problem) {
            this.problem = problem;
            this.previousTime = problem.getInitialTime();
            this.currentTime = problem.getInitialTime();
            this.interpolatedTime = problem.getInitialTime();
        }

        public void readExternal(ObjectInput arg0) {
        }

        public void writeExternal(ObjectOutput arg0) {
        }

        public double getPreviousTime() {
            return this.previousTime;
        }

        public void setPreviousTime(double time) {
            this.previousTime = time;
        }

        public double getCurrentTime() {
            return this.currentTime;
        }

        public void setCurrentTime(double time) {
            this.currentTime = time;
        }

        public double getInterpolatedTime() {
            return this.interpolatedTime;
        }

        public void setInterpolatedTime(double time) {
            this.interpolatedTime = time;
        }

        public double[] getInterpolatedState() {
            return this.problem.computeTheoreticalState(this.interpolatedTime);
        }

        public double[] getInterpolatedDerivatives() {
            double[] y = this.problem.computeTheoreticalState(this.interpolatedTime);
            double[] yDot = new double[y.length];
            this.problem.computeDerivatives(this.interpolatedTime, y, yDot);
            return yDot;
        }

        public double[] getInterpolatedSecondaryState(int index) {
            return null;
        }

        public double[] getInterpolatedSecondaryDerivatives(int index) {
            return null;
        }

        public boolean isForward() {
            return this.problem.getFinalTime() > this.problem.getInitialTime();
        }

        public StepInterpolator copy() {
            return this;
        }
    }

    private static class PerfectStarter
    extends AbstractIntegrator {
        private final PerfectInterpolator interpolator;
        private final int nbSteps;

        public PerfectStarter(TestProblemAbstract problem, int nbSteps) {
            this.interpolator = new PerfectInterpolator(problem);
            this.nbSteps = nbSteps;
        }

        public void integrate(ExpandableStatefulODE equations, double t) {
            double tStart = equations.getTime() + 0.01 * (t - equations.getTime());
            this.getCounter().increment(this.nbSteps);
            for (int i = 0; i < this.nbSteps; ++i) {
                double tK = ((double)(this.nbSteps - 1 - (i + 1)) * equations.getTime() + (double)(i + 1) * tStart) / (double)(this.nbSteps - 1);
                this.interpolator.setPreviousTime(this.interpolator.getCurrentTime());
                this.interpolator.setCurrentTime(tK);
                this.interpolator.setInterpolatedTime(tK);
                for (StepHandler handler : this.getStepHandlers()) {
                    handler.handleStep((StepInterpolator)this.interpolator, i == this.nbSteps - 1);
                }
            }
        }
    }
}

