/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.fitting.leastsquares.AbstractLeastSquaresOptimizerAbstractTest;
import org.apache.commons.math3.fitting.leastsquares.CircleProblem;
import org.apache.commons.math3.fitting.leastsquares.CircleVectorial;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import org.apache.commons.math3.fitting.leastsquares.RandomCirclePointGenerator;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LevenbergMarquardtOptimizerTest
extends AbstractLeastSquaresOptimizerAbstractTest {
    public LeastSquaresBuilder builder(BevingtonProblem problem) {
        return this.base().model(problem.getModelFunction(), problem.getModelFunctionJacobian());
    }

    public LeastSquaresBuilder builder(CircleProblem problem) {
        return this.base().model(problem.getModelFunction(), problem.getModelFunctionJacobian()).target(problem.target()).weight((RealMatrix)new DiagonalMatrix(problem.weight()));
    }

    public int getMaxIterations() {
        return 25;
    }

    public LeastSquaresOptimizer getOptimizer() {
        return new LevenbergMarquardtOptimizer();
    }

    @Test
    public void testNonInvertible() {
        try {
            AbstractLeastSquaresOptimizerAbstractTest.LinearProblem problem = new AbstractLeastSquaresOptimizerAbstractTest.LinearProblem(this, new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
            LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().maxIterations(20).build());
            Assert.assertTrue((FastMath.sqrt((double)problem.getTarget().length) * optimum.getRMS() > 0.6 ? 1 : 0) != 0);
            optimum.getCovariances(1.5E-14);
            this.fail(this.optimizer);
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testControlParameters() {
        CircleVectorial circle = new CircleVectorial();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        this.checkEstimate(circle, 0.1, 10, 1.0E-14, 1.0E-16, 1.0E-10, false);
        this.checkEstimate(circle, 0.1, 10, 1.0E-15, 1.0E-17, 1.0E-10, true);
        this.checkEstimate(circle, 0.1, 5, 1.0E-15, 1.0E-16, 1.0E-10, true);
        circle.addPoint(300.0, -300.0);
        this.checkEstimate(circle, 0.1, 20, 1.0E-18, 1.0E-16, 1.0E-10, false);
    }

    private void checkEstimate(CircleVectorial circle, double initialStepBoundFactor, int maxCostEval, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, boolean shouldFail) {
        try {
            LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer().withInitialStepBoundFactor(initialStepBoundFactor).withCostRelativeTolerance(costRelativeTolerance).withParameterRelativeTolerance(parRelativeTolerance).withOrthoTolerance(orthoTolerance).withRankingThreshold(Precision.SAFE_MIN);
            LeastSquaresProblem problem = this.builder(circle).maxEvaluations(maxCostEval).maxIterations(100).start(new double[]{98.68, 47.345}).build();
            optimizer.optimize(problem);
            Assert.assertTrue((!shouldFail ? 1 : 0) != 0);
        }
        catch (DimensionMismatchException ee) {
            Assert.assertTrue((boolean)shouldFail);
        }
        catch (TooManyEvaluationsException ee) {
            Assert.assertTrue((boolean)shouldFail);
        }
    }

    @Test
    public void testBevington() {
        int i;
        double[][] dataPoints = new double[][]{{15.0, 30.0, 45.0, 60.0, 75.0, 90.0, 105.0, 120.0, 135.0, 150.0, 165.0, 180.0, 195.0, 210.0, 225.0, 240.0, 255.0, 270.0, 285.0, 300.0, 315.0, 330.0, 345.0, 360.0, 375.0, 390.0, 405.0, 420.0, 435.0, 450.0, 465.0, 480.0, 495.0, 510.0, 525.0, 540.0, 555.0, 570.0, 585.0, 600.0, 615.0, 630.0, 645.0, 660.0, 675.0, 690.0, 705.0, 720.0, 735.0, 750.0, 765.0, 780.0, 795.0, 810.0, 825.0, 840.0, 855.0, 870.0, 885.0}, {775.0, 479.0, 380.0, 302.0, 185.0, 157.0, 137.0, 119.0, 110.0, 89.0, 74.0, 61.0, 66.0, 68.0, 48.0, 54.0, 51.0, 46.0, 55.0, 29.0, 28.0, 37.0, 49.0, 26.0, 35.0, 29.0, 31.0, 24.0, 25.0, 35.0, 24.0, 30.0, 26.0, 28.0, 21.0, 18.0, 20.0, 27.0, 17.0, 17.0, 14.0, 17.0, 24.0, 11.0, 22.0, 17.0, 12.0, 10.0, 13.0, 16.0, 9.0, 9.0, 14.0, 21.0, 17.0, 13.0, 12.0, 18.0, 10.0}};
        double[] start = new double[]{10.0, 900.0, 80.0, 27.0, 225.0};
        BevingtonProblem problem = new BevingtonProblem();
        int len = dataPoints[0].length;
        double[] weights = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            problem.addPoint(dataPoints[0][i2], dataPoints[1][i2]);
            weights[i2] = 1.0 / dataPoints[1][i2];
        }
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(this.builder(problem).target(dataPoints[1]).weight((RealMatrix)new DiagonalMatrix(weights)).start(start).maxIterations(20).build());
        RealVector solution = optimum.getPoint();
        double[] expectedSolution = new double[]{10.4, 958.3, 131.4, 33.9, 205.0};
        RealMatrix covarMatrix = optimum.getCovariances(1.0E-14);
        double[][] expectedCovarMatrix = new double[][]{{3.38, -3.69, 27.98, -2.34, -49.24}, {-3.69, 2492.26, 81.89, -69.21, -8.9}, {27.98, 81.89, 468.99, -44.22, -615.44}, {-2.34, -69.21, -44.22, 6.39, 53.8}, {-49.24, -8.9, -615.44, 53.8, 929.45}};
        int numParams = expectedSolution.length;
        for (i = 0; i < numParams; ++i) {
            double error = FastMath.sqrt((double)expectedCovarMatrix[i][i]);
            Assert.assertEquals((String)("Parameter " + i), (double)expectedSolution[i], (double)solution.getEntry(i), (double)error);
        }
        for (i = 0; i < numParams; ++i) {
            for (int j = 0; j < numParams; ++j) {
                Assert.assertEquals((String)("Covariance matrix [" + i + "][" + j + "]"), (double)expectedCovarMatrix[i][j], (double)covarMatrix.getEntry(i, j), (double)FastMath.abs((double)(0.1 * expectedCovarMatrix[i][j])));
            }
        }
    }

    @Test
    public void testCircleFitting2() {
        double xCenter = 123.456;
        double yCenter = 654.321;
        double xSigma = 10.0;
        double ySigma = 15.0;
        double radius = 111.111;
        long seed = 59421061L;
        RandomCirclePointGenerator factory = new RandomCirclePointGenerator(123.456, 654.321, 111.111, 10.0, 15.0, 59421061L);
        CircleProblem circle = new CircleProblem(10.0, 15.0);
        int numPoints = 10;
        for (Vector2D p : factory.generate(10)) {
            circle.addPoint(p.getX(), p.getY());
        }
        double[] init = new double[]{90.0, 659.0, 115.0};
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(this.builder(circle).maxIterations(50).start(init).build());
        double[] paramFound = optimum.getPoint().toArray();
        double[] asymptoticStandardErrorFound = optimum.getSigma(1.0E-14).toArray();
        Assert.assertEquals((double)123.456, (double)paramFound[0], (double)asymptoticStandardErrorFound[0]);
        Assert.assertEquals((double)654.321, (double)paramFound[1], (double)asymptoticStandardErrorFound[1]);
        Assert.assertEquals((double)111.111, (double)paramFound[2], (double)asymptoticStandardErrorFound[2]);
    }

    @Test
    public void testParameterValidator() {
        double xCenter = 123.456;
        double yCenter = 654.321;
        double xSigma = 10.0;
        double ySigma = 15.0;
        double radius = 111.111;
        long seed = 3456789L;
        RandomCirclePointGenerator factory = new RandomCirclePointGenerator(123.456, 654.321, 111.111, 10.0, 15.0, 3456789L);
        CircleProblem circle = new CircleProblem(10.0, 15.0);
        int numPoints = 10;
        for (Vector2D p : factory.generate(10)) {
            circle.addPoint(p.getX(), p.getY());
        }
        double[] init = new double[]{90.0, 659.0, 115.0};
        final LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(this.builder(circle).maxIterations(50).start(init).build());
        int numEval = optimum.getEvaluations();
        Assert.assertTrue((numEval > 1 ? 1 : 0) != 0);
        ParameterValidator cheatValidator = new ParameterValidator(){

            public RealVector validate(RealVector params) {
                return optimum.getPoint();
            }
        };
        LeastSquaresOptimizer.Optimum cheatOptimum = this.optimizer.optimize(this.builder(circle).maxIterations(50).start(init).parameterValidator(cheatValidator).build());
        int cheatNumEval = cheatOptimum.getEvaluations();
        Assert.assertTrue((cheatNumEval < numEval ? 1 : 0) != 0);
    }

    @Test
    public void testEvaluationCount() {
        LeastSquaresProblem lsp = new AbstractLeastSquaresOptimizerAbstractTest.LinearProblem(this, new double[][]{{1.0}}, new double[]{1.0}).getBuilder().checker((ConvergenceChecker)new ConvergenceChecker<LeastSquaresProblem.Evaluation>(){

            public boolean converged(int iteration, LeastSquaresProblem.Evaluation previous, LeastSquaresProblem.Evaluation current) {
                return true;
            }
        }).build();
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(lsp);
        Assert.assertThat((Object)optimum.getIterations(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)optimum.getEvaluations(), (Matcher)CoreMatchers.is((Object)2));
    }

    private static class BevingtonProblem {
        private List<Double> time = new ArrayList<Double>();
        private List<Double> count = new ArrayList<Double>();

        public void addPoint(double t, double c) {
            this.time.add(t);
            this.count.add(c);
        }

        public MultivariateVectorFunction getModelFunction() {
            return new MultivariateVectorFunction(){

                public double[] value(double[] params) {
                    double[] values = new double[BevingtonProblem.this.time.size()];
                    for (int i = 0; i < values.length; ++i) {
                        double t = (Double)BevingtonProblem.this.time.get(i);
                        values[i] = params[0] + params[1] * FastMath.exp((double)(-t / params[3])) + params[2] * FastMath.exp((double)(-t / params[4]));
                    }
                    return values;
                }
            };
        }

        public MultivariateMatrixFunction getModelFunctionJacobian() {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] params) {
                    double[][] jacobian = new double[BevingtonProblem.this.time.size()][5];
                    for (int i = 0; i < jacobian.length; ++i) {
                        double t = (Double)BevingtonProblem.this.time.get(i);
                        jacobian[i][0] = 1.0;
                        double p3 = params[3];
                        double p4 = params[4];
                        double tOp3 = t / p3;
                        double tOp4 = t / p4;
                        jacobian[i][1] = FastMath.exp((double)(-tOp3));
                        jacobian[i][2] = FastMath.exp((double)(-tOp4));
                        jacobian[i][3] = params[1] * FastMath.exp((double)(-tOp3)) * tOp3 / p3;
                        jacobian[i][4] = params[2] * FastMath.exp((double)(-tOp4)) * tOp4 / p4;
                    }
                    return jacobian;
                }
            };
        }
    }
}

