/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertingWrapDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.collections.BeanMap;
import org.apache.commons.jelly.DynaBeanTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.Attribute;
import org.apache.commons.jelly.impl.BeanSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicBeanTag
extends DynaBeanTagSupport
implements BeanSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$impl$DynamicBeanTag == null ? (class$org$apache$commons$jelly$impl$DynamicBeanTag = DynamicBeanTag.class$("org.apache.commons.jelly.impl.DynamicBeanTag")) : class$org$apache$commons$jelly$impl$DynamicBeanTag));
    private static final Object[] emptyArgs = new Object[0];
    private Class beanClass;
    private Object bean;
    private Method method;
    private String variableNameAttribute;
    private String var;
    private Set setAttributesSet = new HashSet();
    private Map attributes;
    static /* synthetic */ Class class$org$apache$commons$jelly$impl$DynamicBeanTag;

    public DynamicBeanTag(Class beanClass, Map attributes, String variableNameAttribute, Method method) {
        this.beanClass = beanClass;
        this.method = method;
        this.attributes = attributes;
        this.variableNameAttribute = variableNameAttribute;
    }

    public void beforeSetAttributes() throws JellyTagException {
        try {
            this.bean = this.beanClass.newInstance();
            this.setDynaBean((DynaBean)new ConvertingWrapDynaBean(this.bean));
        }
        catch (InstantiationException e) {
            throw new JellyTagException("Could not instantiate dynabean", e);
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException("Could not instantiate dynabean", e);
        }
        this.setAttributesSet.clear();
    }

    public void setAttribute(String name, Object value) throws JellyTagException {
        boolean isVariableName = false;
        if (this.variableNameAttribute != null && this.variableNameAttribute.equals(name)) {
            this.var = value == null ? null : value.toString();
            isVariableName = true;
        }
        if (!isVariableName) {
            this.setAttributesSet.add(name);
            super.setAttribute(name, value);
        }
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        Iterator iter = this.attributes.values().iterator();
        while (iter.hasNext()) {
            Attribute attribute = (Attribute)iter.next();
            String name = attribute.getName();
            if (this.setAttributesSet.contains(name)) continue;
            if (attribute.isRequired()) {
                throw new MissingAttributeException(name);
            }
            Object value = null;
            Expression expression = attribute.getDefaultValue();
            if (expression != null) {
                value = expression.evaluate(this.context);
            }
            if (value == null) continue;
            super.setAttribute(name, value);
        }
        if (this.bean instanceof Tag) {
            Tag tag = (Tag)this.bean;
            tag.setBody(this.getBody());
            tag.setContext(this.getContext());
            tag.setParent(this.getParent());
            ((Tag)this.bean).doTag(output);
            return;
        }
        this.invokeBody(output);
        if (this.var != null) {
            this.context.setVariable(this.var, this.bean);
        }
        if (this.method != null) {
            try {
                this.method.invoke(this.bean, emptyArgs);
            }
            catch (IllegalAccessException e) {
                this.methodInvocationException(this.bean, this.method, e);
            }
            catch (IllegalArgumentException e) {
                this.methodInvocationException(this.bean, this.method, e);
            }
            catch (InvocationTargetException e) {
                Throwable inner = e.getTargetException();
                throw new JellyTagException(inner);
            }
        }
    }

    private void methodInvocationException(Object bean, Method method, Exception e) throws JellyTagException {
        log.error((Object)("Could not invoke " + method), (Throwable)e);
        BeanMap beanMap = new BeanMap(bean);
        log.error((Object)"Bean properties:");
        Iterator i = beanMap.keySet().iterator();
        while (i.hasNext()) {
            String property = (String)i.next();
            Object value = beanMap.get((Object)property);
            log.error((Object)(property + " -> " + value));
        }
        log.error((Object)beanMap);
        throw new JellyTagException(e);
    }

    public Object getBean() {
        return this.bean;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

