/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import junit.framework.TestSuite;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.core.Customer;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestInvokeTag
extends BaseJellyTest {
    public TestInvokeTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestInvokeTag.class);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSimpleInvoke() throws Exception {
        this.setUpScript("testInvokeTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.simpleInvoke", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestInvokeTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestInvokeTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestInvokeTag.assertEquals((String)"Chicago", (String)customer.getCity());
        TestInvokeTag.assertNotNull((Object)customer.getOrders());
        TestInvokeTag.assertEquals((int)1, (int)customer.getOrders().size());
        TestInvokeTag.assertNotNull(customer.getOrders().get(0));
    }

    public void testInvokeWithVar() throws Exception {
        this.setUpScript("testInvokeTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeWithVar", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("size"));
        TestInvokeTag.assertTrue((boolean)(this.getJellyContext().getVariable("size") instanceof Integer));
        Integer size = (Integer)this.getJellyContext().getVariable("size");
        TestInvokeTag.assertEquals((int)3, (int)size);
    }

    public void testInvokeWithReturnedValueAsArg() throws Exception {
        this.setUpScript("testInvokeTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeWithReturnedValueAsArg", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("customer"));
        TestInvokeTag.assertTrue((boolean)(this.getJellyContext().getVariable("customer") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("customer");
        TestInvokeTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestInvokeTag.assertEquals((String)"Chicago", (String)customer.getCity());
    }

    public void testInvokeWithReturnedValueAsArgAndVar() throws Exception {
        this.setUpScript("testInvokeTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeWithReturnedValueAsArgAndVar", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("customer"));
        TestInvokeTag.assertTrue((boolean)(this.getJellyContext().getVariable("customer") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("customer");
        TestInvokeTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestInvokeTag.assertEquals((String)"Chicago", (String)customer.getCity());
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("argtwo"));
        TestInvokeTag.assertEquals((Object)"Chicago", (Object)this.getJellyContext().getVariable("argtwo"));
    }

    public void testInvokeThatThrowsException() throws Exception {
        this.setUpScript("testInvokeTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeThatThrowsException", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        String exceptionMessage = (String)this.getJellyContext().getVariable("exceptionMessage");
        TestInvokeTag.assertNotNull((Object)exceptionMessage);
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("exceptionBean"));
        Exception jellyException = (Exception)this.getJellyContext().getVariable("jellyException");
        TestInvokeTag.assertNull((Object)jellyException);
        Exception exception = (Exception)this.getJellyContext().getVariable("exceptionThrown");
        TestInvokeTag.assertNotNull((Object)exception);
        TestInvokeTag.assertEquals((String)exceptionMessage, (String)exception.getMessage());
    }

    public void testInvokeThatDoesNotHandleException() throws Exception {
        this.setUpScript("testInvokeTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeThatDoesNotHandleException", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        String exceptionMessage = (String)this.getJellyContext().getVariable("exceptionMessage");
        TestInvokeTag.assertNotNull((Object)exceptionMessage);
        TestInvokeTag.assertNotNull((Object)this.getJellyContext().getVariable("exceptionBean"));
        JellyException jellyException = (JellyException)((Object)this.getJellyContext().getVariable("jellyException"));
        TestInvokeTag.assertNotNull((Object)((Object)jellyException));
        TestInvokeTag.assertTrue((String)"messages are the same", (!exceptionMessage.equals(jellyException.getMessage()) ? 1 : 0) != 0);
        TestInvokeTag.assertTrue((String)("exception '" + jellyException.getMessage() + "' does not ends with '" + exceptionMessage + "'"), (boolean)jellyException.getMessage().endsWith(exceptionMessage));
        TestInvokeTag.assertNotNull((Object)jellyException.getCause());
        TestInvokeTag.assertEquals((String)exceptionMessage, (String)jellyException.getCause().getMessage());
    }
}

