/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory.fifo;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.memory.fifo.FIFOMemoryCache;

public class FIFOMemoryCacheUnitTest
extends TestCase {
    public void testExpirationPolicy_oneExtra() throws IOException {
        int maxObjects = 10;
        String cacheName = "testExpirationPolicy_oneExtra";
        CompositeCacheAttributes attributes = new CompositeCacheAttributes();
        attributes.setCacheName("testExpirationPolicy_oneExtra");
        attributes.setMaxObjects(10);
        attributes.setSpoolChunkSize(1);
        FIFOMemoryCache cache = new FIFOMemoryCache();
        cache.initialize(new CompositeCache((ICompositeCacheAttributes)attributes, (IElementAttributes)new ElementAttributes()));
        for (int i = 0; i <= 10; ++i) {
            CacheElement element = new CacheElement("testExpirationPolicy_oneExtra", (Object)("key" + i), (Object)("value" + i));
            cache.update((ICacheElement)element);
        }
        CacheElement oneMoreElement = new CacheElement("testExpirationPolicy_oneExtra", (Object)"onemore", (Object)"onemore");
        cache.update((ICacheElement)oneMoreElement);
        FIFOMemoryCacheUnitTest.assertEquals((String)"Should have max elements", (int)10, (int)cache.getSize());
        System.out.println(cache.getKeySet());
        for (int i = 10; i > 1; --i) {
            FIFOMemoryCacheUnitTest.assertNotNull((String)("Should have element " + i), (Object)cache.get((Object)("key" + i)));
        }
        FIFOMemoryCacheUnitTest.assertNotNull((String)"Should have oneMoreElement", (Object)cache.get((Object)"onemore"));
    }

    public void testExpirationPolicy_doubleOver() throws IOException {
        int i;
        int maxObjects = 10;
        String cacheName = "testExpirationPolicy_oneExtra";
        CompositeCacheAttributes attributes = new CompositeCacheAttributes();
        attributes.setCacheName("testExpirationPolicy_oneExtra");
        attributes.setMaxObjects(10);
        attributes.setSpoolChunkSize(1);
        FIFOMemoryCache cache = new FIFOMemoryCache();
        cache.initialize(new CompositeCache((ICompositeCacheAttributes)attributes, (IElementAttributes)new ElementAttributes()));
        for (i = 0; i <= 20; ++i) {
            CacheElement element = new CacheElement("testExpirationPolicy_oneExtra", (Object)("key" + i), (Object)("value" + i));
            cache.update((ICacheElement)element);
        }
        FIFOMemoryCacheUnitTest.assertEquals((String)"Should have max elements", (int)10, (int)cache.getSize());
        for (i = 20; i > 10; --i) {
            FIFOMemoryCacheUnitTest.assertNotNull((String)("Shjould have elemnt " + i), (Object)cache.get((Object)("key" + i)));
        }
    }
}

