/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.text.DecimalFormat;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.disk.DiskTestObject;

public class BlockDiskCacheSteadyLoadTest
extends TestCase {
    private static final String LOG_DIVIDER = "---------------------------";
    private static final Runtime rt = Runtime.getRuntime();
    private static final DecimalFormat format = new DecimalFormat("#,###");

    public void testRunSteadyLoadTest() throws Exception {
        JCS.setConfigFilename((String)"/TestBlockDiskCacheSteadyLoad.ccf");
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        int numPerRun = 250;
        long pauseBetweenRuns = 1000L;
        int runCount = 0;
        int runs = 1000;
        int upperKB = 50;
        CacheAccess jcs = JCS.getInstance((String)"125aSecond");
        int numToGet = 25000;
        for (int i = 0; i < 25000; ++i) {
            jcs.get((Object)String.valueOf(i));
        }
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        jcs.clear();
        Thread.sleep(3000L);
        int totalPut = 0;
        Random random = new Random(89L);
        while (runCount < 1000) {
            int j;
            ++runCount;
            for (int i = 0; i < 250; ++i) {
                int kiloBytes = Math.max(25, random.nextInt(50));
                int bytes = kiloBytes * 1024;
                DiskTestObject object = new DiskTestObject(i, new byte[bytes]);
                jcs.put((Object)String.valueOf(++totalPut), (Object)object);
            }
            if (runCount > 1) {
                for (j = totalPut - 250 - 125; j < totalPut - 250; ++j) {
                    jcs.get((Object)String.valueOf(j));
                }
            }
            if (runCount > 1) {
                for (j = totalPut - 250 - 125; j < totalPut - 250; ++j) {
                    jcs.remove((Object)String.valueOf(j));
                }
            }
            Thread.sleep(1000L);
            if (runCount % 100 != 0) continue;
            BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        }
        Thread.sleep(3000L);
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        Thread.sleep(10000L);
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        BlockDiskCacheSteadyLoadTest.logMemoryUsage();
    }

    private static void logMemoryUsage() {
        long byte2MB = 0x100000L;
        long total = rt.totalMemory() / 0x100000L;
        long free = rt.freeMemory() / 0x100000L;
        long used = total - free;
        System.out.println(LOG_DIVIDER);
        System.out.println("Memory: Used:" + format.format(used) + "MB Free:" + format.format(free) + "MB Total:" + format.format(total) + "MB");
    }
}

