/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import junit.framework.TestCase;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.classes.SimpleDump;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingClassLoaderRemoveTestCase
extends TestCase {
    private final Log log = LogFactory.getLog(ReloadingClassLoaderRemoveTestCase.class);
    private final byte[] clazzSimpleA;
    private MemoryResourceStore store1 = new MemoryResourceStore();
    private MemoryResourceStore store2 = new MemoryResourceStore();
    private MemoryResourceStore store3 = new MemoryResourceStore();
    private MemoryResourceStore store4 = new MemoryResourceStore();

    public ReloadingClassLoaderRemoveTestCase() throws Exception {
        this.clazzSimpleA = SimpleDump.dump("SimpleA");
        ReloadingClassLoaderRemoveTestCase.assertTrue((this.clazzSimpleA.length > 0 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
    }

    protected void tearDown() throws Exception {
    }

    public void testRemoveStoreNotFoundClassLoaderNoStores() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.checkRemoveResourceStore("No ResourceStore", loader, (ResourceStore)this.store1, false);
    }

    public void testRemoveStoreNotFoundClassLoaderHasStores() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.addResourceStore((ResourceStore)this.store1);
        loader.addResourceStore((ResourceStore)this.store2);
        this.checkRemoveResourceStore("Has ResourceStore", loader, (ResourceStore)this.store3, false);
    }

    public void testRemoveStoresOne() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.addResourceStore((ResourceStore)this.store1);
        loader.addResourceStore((ResourceStore)this.store2);
        loader.addResourceStore((ResourceStore)this.store3);
        loader.addResourceStore((ResourceStore)this.store4);
        this.checkRemoveResourceStore("One: Remove Store 1", loader, (ResourceStore)this.store1, true);
        this.checkRemoveResourceStore("One: Store 1 Not Found", loader, (ResourceStore)this.store1, false);
        this.checkRemoveResourceStore("One: Remove Store 2", loader, (ResourceStore)this.store2, true);
        this.checkRemoveResourceStore("One: Store 2 Not Found", loader, (ResourceStore)this.store2, false);
        this.checkRemoveResourceStore("One: Remove Store 3", loader, (ResourceStore)this.store3, true);
        this.checkRemoveResourceStore("One: Store 3 Not Found", loader, (ResourceStore)this.store3, false);
        this.checkRemoveResourceStore("One: Remove Store 4", loader, (ResourceStore)this.store4, true);
        this.checkRemoveResourceStore("One: Store 4 Not Found", loader, (ResourceStore)this.store4, false);
    }

    public void testRemoveStoresTwo() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.addResourceStore((ResourceStore)this.store1);
        loader.addResourceStore((ResourceStore)this.store2);
        loader.addResourceStore((ResourceStore)this.store3);
        loader.addResourceStore((ResourceStore)this.store4);
        this.checkRemoveResourceStore("Two: Remove Store 2", loader, (ResourceStore)this.store2, true);
        this.checkRemoveResourceStore("Two: Store 2 Not Found", loader, (ResourceStore)this.store2, false);
        this.checkRemoveResourceStore("Two: Remove Store 4", loader, (ResourceStore)this.store4, true);
        this.checkRemoveResourceStore("Two: Store 4 Not Found", loader, (ResourceStore)this.store4, false);
        this.checkRemoveResourceStore("Two: Remove Store 3", loader, (ResourceStore)this.store3, true);
        this.checkRemoveResourceStore("Two: Store 3 Not Found", loader, (ResourceStore)this.store3, false);
        this.checkRemoveResourceStore("Two: Remove Store 1", loader, (ResourceStore)this.store1, true);
        this.checkRemoveResourceStore("Two: Store 1 Not Found", loader, (ResourceStore)this.store1, false);
    }

    public void testRemoveStoresThree() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.addResourceStore((ResourceStore)this.store1);
        loader.addResourceStore((ResourceStore)this.store2);
        loader.addResourceStore((ResourceStore)this.store3);
        loader.addResourceStore((ResourceStore)this.store4);
        this.checkRemoveResourceStore("Three: Remove Store 3", loader, (ResourceStore)this.store3, true);
        this.checkRemoveResourceStore("Three: Store 3 Not Found", loader, (ResourceStore)this.store3, false);
        this.checkRemoveResourceStore("Three: Remove Store 1", loader, (ResourceStore)this.store1, true);
        this.checkRemoveResourceStore("Three: Store 1 Not Found", loader, (ResourceStore)this.store1, false);
        this.checkRemoveResourceStore("Three: Remove Store 4", loader, (ResourceStore)this.store4, true);
        this.checkRemoveResourceStore("Three: Store 4 Not Found", loader, (ResourceStore)this.store4, false);
        this.checkRemoveResourceStore("Three: Remove Store 2", loader, (ResourceStore)this.store2, true);
        this.checkRemoveResourceStore("Three: Store 2 Not Found", loader, (ResourceStore)this.store2, false);
    }

    public void testRemoveStoresFour() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.addResourceStore((ResourceStore)this.store1);
        loader.addResourceStore((ResourceStore)this.store2);
        loader.addResourceStore((ResourceStore)this.store3);
        loader.addResourceStore((ResourceStore)this.store4);
        this.checkRemoveResourceStore("Four: Remove Store 4", loader, (ResourceStore)this.store4, true);
        this.checkRemoveResourceStore("Four: Store 4 Not Found", loader, (ResourceStore)this.store4, false);
        this.checkRemoveResourceStore("Four: Remove Store 3", loader, (ResourceStore)this.store3, true);
        this.checkRemoveResourceStore("Four: Store 3 Not Found", loader, (ResourceStore)this.store3, false);
        this.checkRemoveResourceStore("Four: Remove Store 2", loader, (ResourceStore)this.store2, true);
        this.checkRemoveResourceStore("Four: Store 2 Not Found", loader, (ResourceStore)this.store2, false);
        this.checkRemoveResourceStore("Four: Remove Store 1", loader, (ResourceStore)this.store1, true);
        this.checkRemoveResourceStore("Four: Store 1 Not Found", loader, (ResourceStore)this.store1, false);
    }

    public void testLoadClassAfterResourceStoreRemoved() {
        ReloadingClassLoader loader = new ReloadingClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        MemoryResourceStore store = new MemoryResourceStore();
        loader.addResourceStore((ResourceStore)store);
        try {
            loader.loadClass("jci.Simple").newInstance();
            ReloadingClassLoaderRemoveTestCase.fail((String)"Success loadClass[1]");
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            this.log.error((Object)e);
            ReloadingClassLoaderRemoveTestCase.fail((String)("Error loadClass[1]: " + e));
        }
        String toStringValue = "FooBar";
        try {
            byte[] classBytes = SimpleDump.dump(toStringValue);
            store.write("jci/Simple.class", classBytes);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            ReloadingClassLoaderRemoveTestCase.fail((String)("Error adding class to store: " + e));
        }
        try {
            Object simple2 = loader.loadClass("jci.Simple").newInstance();
            ReloadingClassLoaderRemoveTestCase.assertNotNull((String)"Found loadClass[2]", simple2);
            ReloadingClassLoaderRemoveTestCase.assertEquals((String)"toString loadClass[2]", (String)toStringValue, (String)simple2.toString());
        }
        catch (Exception e) {
            this.log.error((Object)e);
            ReloadingClassLoaderRemoveTestCase.fail((String)("Error loadClass[2]: " + e));
        }
        this.checkRemoveResourceStore("Remove Resource Store", loader, (ResourceStore)store, true);
        try {
            loader.loadClass("jci.Simple").newInstance();
            ReloadingClassLoaderRemoveTestCase.fail((String)"Success loadClass[3]");
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            this.log.error((Object)e);
            ReloadingClassLoaderRemoveTestCase.fail((String)("Error loadClass[3]: " + e));
        }
    }

    private void checkRemoveResourceStore(String label, ReloadingClassLoader loader, ResourceStore store, boolean expected) {
        try {
            ReloadingClassLoaderRemoveTestCase.assertEquals((String)label, (boolean)expected, (boolean)loader.removeResourceStore(store));
        }
        catch (Exception e) {
            this.log.error((Object)label, (Throwable)e);
            ReloadingClassLoaderRemoveTestCase.fail((String)(label + " failed: " + e));
        }
    }
}

