/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;
import org.apache.commons.geometry.spherical.oned.CutAngle;
import org.apache.commons.geometry.spherical.oned.CutAngles;
import org.apache.commons.geometry.spherical.oned.RegionBSPTree1S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatCircle;
import org.apache.commons.geometry.spherical.twod.GreatCircleSubset;
import org.apache.commons.geometry.spherical.twod.GreatCircles;
import org.apache.commons.geometry.spherical.twod.Point2S;

public final class EmbeddedTreeGreatCircleSubset
extends GreatCircleSubset {
    private final RegionBSPTree1S region;

    public EmbeddedTreeGreatCircleSubset(GreatCircle greatCircle) {
        this(greatCircle, false);
    }

    public EmbeddedTreeGreatCircleSubset(GreatCircle circle, boolean full) {
        this(circle, new RegionBSPTree1S(full));
    }

    public EmbeddedTreeGreatCircleSubset(GreatCircle circle, RegionBSPTree1S region) {
        super(circle);
        this.region = region;
    }

    public RegionBSPTree1S getSubspaceRegion() {
        return this.region;
    }

    public EmbeddedTreeGreatCircleSubset transform(Transform<Point2S> transform) {
        GreatCircle circle = this.getCircle().transform(transform);
        return new EmbeddedTreeGreatCircleSubset(circle, this.region.copy());
    }

    @Override
    public List<GreatArc> toConvex() {
        return this.region.toIntervals().stream().flatMap(i -> i.toConvex().stream()).map(i -> GreatCircles.arcFromInterval(this.getCircle(), i)).collect(Collectors.toList());
    }

    public Split<EmbeddedTreeGreatCircleSubset> split(Hyperplane<Point2S> splitter) {
        GreatCircle splitterCircle = (GreatCircle)splitter;
        GreatCircle thisCircle = this.getCircle();
        Point2S intersection = splitterCircle.intersection(thisCircle);
        EmbeddedTreeGreatCircleSubset minus = null;
        EmbeddedTreeGreatCircleSubset plus = null;
        if (intersection != null) {
            CutAngle subSplitter = CutAngles.createPositiveFacing(thisCircle.toSubspace(intersection), splitterCircle.getPrecision());
            Split<RegionBSPTree1S> subSplit = this.region.splitDiameter(subSplitter);
            SplitLocation subLoc = subSplit.getLocation();
            if (subLoc == SplitLocation.MINUS) {
                minus = this;
            } else if (subLoc == SplitLocation.PLUS) {
                plus = this;
            } else if (subLoc == SplitLocation.BOTH) {
                minus = new EmbeddedTreeGreatCircleSubset(thisCircle, (RegionBSPTree1S)((Object)subSplit.getMinus()));
                plus = new EmbeddedTreeGreatCircleSubset(thisCircle, (RegionBSPTree1S)((Object)subSplit.getPlus()));
            }
        }
        return new Split(minus, plus);
    }

    public void add(GreatArc arc) {
        GreatCircles.validateGreatCirclesEquivalent(this.getCircle(), arc.getCircle());
        this.region.add(arc.getSubspaceRegion());
    }

    public void add(EmbeddedTreeGreatCircleSubset subcircle) {
        GreatCircles.validateGreatCirclesEquivalent(this.getCircle(), subcircle.getCircle());
        this.region.union(subcircle.getSubspaceRegion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[').append("circle= ").append((Object)this.getCircle()).append(", region= ").append((Object)this.region).append(']');
        return sb.toString();
    }
}

