/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.input;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.geometry.io.core.AbstractGeometryIOMetadata;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;

public class UrlGeometryInput
extends AbstractGeometryIOMetadata
implements GeometryInput {
    private final URL url;

    public UrlGeometryInput(URL url) {
        this(url, null);
    }

    public UrlGeometryInput(URL url, Charset charset) {
        super(GeometryIOUtils.getFileName(url), charset);
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getInputStream() {
        return GeometryIOUtils.getUnchecked(() -> new BufferedInputStream(this.url.openStream()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[url= ").append(this.getUrl()).append(']');
        return sb.toString();
    }
}

