/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.oned.RegionBSPTree1D;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.LineSubset3D;
import org.apache.commons.geometry.euclidean.threed.line.Lines3D;

public final class EmbeddedTreeLineSubset3D
extends LineSubset3D {
    private final RegionBSPTree1D region;

    public EmbeddedTreeLineSubset3D(Line3D line) {
        this(line, false);
    }

    public EmbeddedTreeLineSubset3D(Line3D line, boolean full) {
        this(line, new RegionBSPTree1D(full));
    }

    public EmbeddedTreeLineSubset3D(Line3D line, RegionBSPTree1D region) {
        super(line);
        this.region = region;
    }

    public double getSize() {
        return this.region.getSize();
    }

    public RegionBSPTree1D getSubspaceRegion() {
        return this.region;
    }

    @Override
    public Vector3D getCentroid() {
        Vector1D subcenter = (Vector1D)this.region.getCentroid();
        return subcenter != null ? this.getLine().toSpace(subcenter) : null;
    }

    @Override
    public Bounds3D getBounds() {
        double min = this.region.getMin();
        double max = this.region.getMax();
        if (Double.isFinite(min) && Double.isFinite(max)) {
            Line3D line = this.getLine();
            return Bounds3D.builder().add(line.toSpace(min)).add(line.toSpace(max)).build();
        }
        return null;
    }

    public EmbeddedTreeLineSubset3D transform(Transform<Vector3D> transform) {
        Line3D.SubspaceTransform st = this.getLine().subspaceTransform(transform);
        RegionBSPTree1D tRegion = RegionBSPTree1D.empty();
        tRegion.copy((BSPTree)this.region);
        tRegion.transform(st.getTransform());
        return new EmbeddedTreeLineSubset3D(st.getLine(), tRegion);
    }

    public List<LineConvexSubset3D> toConvex() {
        List<Interval> intervals = this.region.toIntervals();
        Line3D line = this.getLine();
        ArrayList<LineConvexSubset3D> convex = new ArrayList<LineConvexSubset3D>(intervals.size());
        for (Interval interval : intervals) {
            convex.add(Lines3D.subsetFromInterval(line, interval));
        }
        return convex;
    }

    public String toString() {
        Line3D line = this.getLine();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[').append("lineOrigin= ").append(line.getOrigin()).append(", lineDirection= ").append(line.getDirection()).append(", region= ").append((Object)this.region).append(']');
        return sb.toString();
    }
}

