/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.oned;

import java.util.function.UnaryOperator;
import org.apache.commons.geometry.euclidean.AbstractAffineTransformMatrix;
import org.apache.commons.geometry.euclidean.internal.Matrices;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.oned.Vector1D;

public final class AffineTransformMatrix1D
extends AbstractAffineTransformMatrix<Vector1D, AffineTransformMatrix1D> {
    private static final int NUM_ELEMENTS = 2;
    private static final String MATRIX_START = "[ ";
    private static final String MATRIX_END = " ]";
    private static final String ELEMENT_SEPARATOR = ", ";
    private static final AffineTransformMatrix1D IDENTITY_INSTANCE = new AffineTransformMatrix1D(1.0, 0.0);
    private final double m00;
    private final double m01;

    private AffineTransformMatrix1D(double m00, double m01) {
        this.m00 = m00;
        this.m01 = m01;
    }

    public double[] toArray() {
        return new double[]{this.m00, this.m01};
    }

    public Vector1D apply(Vector1D vec) {
        return Vector1D.of(this.applyX(vec.getX()));
    }

    public double applyX(double x) {
        return this.applyVectorX(x) + this.m01;
    }

    @Override
    public Vector1D applyVector(Vector1D vec) {
        return Vector1D.of(this.applyVectorX(vec.getX()));
    }

    public double applyVectorX(double x) {
        return x * this.m00;
    }

    @Override
    public Vector1D.Unit applyDirection(Vector1D vec) {
        return Vector1D.Unit.from(this.applyVectorX(vec.getX()));
    }

    @Override
    public double determinant() {
        return this.m00;
    }

    @Override
    public AffineTransformMatrix1D linear() {
        return new AffineTransformMatrix1D(this.m00, 0.0);
    }

    @Override
    public AffineTransformMatrix1D linearTranspose() {
        return this.linear();
    }

    public AffineTransformMatrix1D translate(Vector1D translation) {
        return this.translate(translation.getX());
    }

    public AffineTransformMatrix1D translate(double x) {
        return new AffineTransformMatrix1D(this.m00, this.m01 + x);
    }

    public AffineTransformMatrix1D scale(Vector1D scaleFactor) {
        return this.scale(scaleFactor.getX());
    }

    public AffineTransformMatrix1D scale(double x) {
        return new AffineTransformMatrix1D(this.m00 * x, this.m01 * x);
    }

    public AffineTransformMatrix1D multiply(AffineTransformMatrix1D m) {
        return AffineTransformMatrix1D.multiply(this, m);
    }

    public AffineTransformMatrix1D premultiply(AffineTransformMatrix1D m) {
        return AffineTransformMatrix1D.multiply(m, this);
    }

    @Override
    public AffineTransformMatrix1D inverse() {
        double det = Matrices.checkDeterminantForInverse(this.determinant());
        Matrices.checkElementForInverse(this.m01);
        double invDet = 1.0 / det;
        double c01 = -(this.m01 * invDet);
        return new AffineTransformMatrix1D(invDet, c01);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + Double.hashCode(this.m00);
        result = result * 31 + Double.hashCode(this.m01);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransformMatrix1D)) {
            return false;
        }
        AffineTransformMatrix1D other = (AffineTransformMatrix1D)obj;
        return Double.compare(this.m00, other.m00) == 0 && Double.compare(this.m01, other.m01) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MATRIX_START).append(this.m00).append(ELEMENT_SEPARATOR).append(this.m01).append(MATRIX_END);
        return sb.toString();
    }

    public static AffineTransformMatrix1D of(double ... arr) {
        if (arr.length != 2) {
            throw new IllegalArgumentException("Dimension mismatch: " + arr.length + " != " + 2);
        }
        return new AffineTransformMatrix1D(arr[0], arr[1]);
    }

    public static AffineTransformMatrix1D from(UnaryOperator<Vector1D> fn) {
        Vector1D tOne = (Vector1D)fn.apply(Vector1D.Unit.PLUS);
        Vector1D tZero = (Vector1D)fn.apply(Vector1D.ZERO);
        double scale = tOne.subtract(tZero).getX();
        double translate = tZero.getX();
        AffineTransformMatrix1D mat = AffineTransformMatrix1D.of(scale, translate);
        double det = mat.determinant();
        if (!Vectors.isRealNonZero(det)) {
            throw new IllegalArgumentException("Transform function is invalid: matrix determinant is " + det);
        }
        return mat;
    }

    public static AffineTransformMatrix1D identity() {
        return IDENTITY_INSTANCE;
    }

    public static AffineTransformMatrix1D createTranslation(Vector1D translation) {
        return AffineTransformMatrix1D.createTranslation(translation.getX());
    }

    public static AffineTransformMatrix1D createTranslation(double x) {
        return new AffineTransformMatrix1D(1.0, x);
    }

    public static AffineTransformMatrix1D createScale(Vector1D factor) {
        return AffineTransformMatrix1D.createScale(factor.getX());
    }

    public static AffineTransformMatrix1D createScale(double factor) {
        return new AffineTransformMatrix1D(factor, 0.0);
    }

    private static AffineTransformMatrix1D multiply(AffineTransformMatrix1D a, AffineTransformMatrix1D b) {
        double c00 = a.m00 * b.m00;
        double c01 = a.m00 * b.m01 + a.m01;
        return new AffineTransformMatrix1D(c00, c01);
    }
}

