/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationErrorListenerImpl;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.DynamicCombinedConfiguration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.event.ConfigurationListenerTestImpl;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

public class TestDefaultConfigurationBuilder {
    private static final File TEST_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
    private static final File ADDITIONAL_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration2.xml");
    private static final File OPTIONAL_FILE = ConfigurationAssert.getTestFile("testDigesterOptionalConfiguration.xml");
    private static final File OPTIONALEX_FILE = ConfigurationAssert.getTestFile("testDigesterOptionalConfigurationEx.xml");
    private static final File MULTI_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration3.xml");
    private static final File INIT_FILE = ConfigurationAssert.getTestFile("testComplexInitialization.xml");
    private static final File CLASS_FILE = ConfigurationAssert.getTestFile("testExtendedClass.xml");
    private static final File PROVIDER_FILE = ConfigurationAssert.getTestFile("testConfigurationProvider.xml");
    private static final File EXTENDED_PROVIDER_FILE = ConfigurationAssert.getTestFile("testExtendedXMLConfigurationProvider.xml");
    private static final File GLOBAL_LOOKUP_FILE = ConfigurationAssert.getTestFile("testGlobalLookup.xml");
    private static final File SYSTEM_PROPS_FILE = ConfigurationAssert.getTestFile("testSystemProperties.xml");
    private static final File VALIDATION_FILE = ConfigurationAssert.getTestFile("testValidation.xml");
    private static final File VALIDATION3_FILE = ConfigurationAssert.getTestFile("testValidation3.xml");
    private static final File MULTI_TENENT_FILE = ConfigurationAssert.getTestFile("testMultiTenentConfigurationBuilder.xml");
    private static final File EXPRESSION_FILE = ConfigurationAssert.getTestFile("testExpression.xml");
    private static final String OPTIONAL_NAME = "optionalConfig";
    DefaultConfigurationBuilder factory;

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.configuration.MockInitialContextFactory");
        System.setProperty("test_file_xml", "test.xml");
        System.setProperty("test_file_combine", "testcombine1.xml");
        this.factory = new DefaultConfigurationBuilder();
        this.factory.clearErrorListeners();
    }

    @Test
    public void testConfigurationDeclarationIsReserved() {
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory);
        DefaultConfigurationNode parent = new DefaultConfigurationNode();
        DefaultConfigurationNode nd = new DefaultConfigurationNode("at");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Attribute at not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("optional");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Attribute optional not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("config-class");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Inherited attribute not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("different");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertFalse((String)"Wrong reserved attribute", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("at");
        parent.addChild((ConfigurationNode)nd);
        Assert.assertFalse((String)"Node type not evaluated", (boolean)decl.isReservedNode((ConfigurationNode)nd));
    }

    @Test
    public void testConfigurationDeclarationIsReservedAt() {
        this.checkOldReservedAttribute("at");
    }

    @Test
    public void testConfigurationDeclarationIsReservedOptional() {
        this.checkOldReservedAttribute("optional");
    }

    private void checkOldReservedAttribute(String name) {
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory);
        DefaultConfigurationNode parent = new DefaultConfigurationNode();
        DefaultConfigurationNode nd = new DefaultConfigurationNode("config-" + name);
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)("config-" + name + " attribute not recognized"), (boolean)decl.isReservedNode((ConfigurationNode)nd));
        DefaultConfigurationNode nd2 = new DefaultConfigurationNode(name);
        parent.addAttribute((ConfigurationNode)nd2);
        Assert.assertFalse((String)(name + " is reserved though config- exists"), (boolean)decl.isReservedNode((ConfigurationNode)nd2));
        Assert.assertTrue((String)("config- attribute not recognized when " + name + " exists"), (boolean)decl.isReservedNode((ConfigurationNode)nd));
    }

    public void testConfigurationDeclarationGetAttributes() {
        this.factory.addProperty("xml.fileName", (Object)"test.xml");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("xml"));
        Assert.assertNull((String)"Found an at attribute", (Object)decl.getAt());
        Assert.assertFalse((String)"Found an optional attribute", (boolean)decl.isOptional());
        this.factory.addProperty("xml[@config-at]", (Object)"test1");
        Assert.assertEquals((String)"Wrong value of at attribute", (Object)"test1", (Object)decl.getAt());
        this.factory.addProperty("xml[@at]", (Object)"test2");
        Assert.assertEquals((String)"Wrong value of config-at attribute", (Object)"test1", (Object)decl.getAt());
        this.factory.clearProperty("xml[@config-at]");
        Assert.assertEquals((String)"Old at attribute not detected", (Object)"test2", (Object)decl.getAt());
        this.factory.addProperty("xml[@config-optional]", (Object)"true");
        Assert.assertTrue((String)"Wrong value of optional attribute", (boolean)decl.isOptional());
        this.factory.addProperty("xml[@optional]", (Object)"false");
        Assert.assertTrue((String)"Wrong value of config-optional attribute", (boolean)decl.isOptional());
        this.factory.clearProperty("xml[@config-optional]");
        this.factory.setProperty("xml[@optional]", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"Old optional attribute not detected", (boolean)decl.isOptional());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationDeclarationOptionalAttributeInvalid() {
        this.factory.addProperty("xml.fileName", (Object)"test.xml");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("xml"));
        this.factory.setProperty("xml[@optional]", (Object)"invalid value");
        decl.isOptional();
    }

    @Test
    public void testAddConfigurationProvider() {
        DefaultConfigurationBuilder.ConfigurationProvider provider = new DefaultConfigurationBuilder.ConfigurationProvider();
        Assert.assertNull((String)"Provider already registered", (Object)this.factory.providerForTag("test"));
        this.factory.addConfigurationProvider("test", provider);
        Assert.assertSame((String)"Provider not registered", (Object)provider, (Object)this.factory.providerForTag("test"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConfigurationProviderNull() {
        this.factory.addConfigurationProvider("test", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConfigurationProviderNullTag() {
        this.factory.addConfigurationProvider(null, new DefaultConfigurationBuilder.ConfigurationProvider());
    }

    @Test
    public void testRemoveConfigurationProvider() {
        Assert.assertNull((String)"Removing unknown provider", (Object)this.factory.removeConfigurationProvider("test"));
        Assert.assertNull((String)"Removing provider for null tag", (Object)this.factory.removeConfigurationProvider(null));
        DefaultConfigurationBuilder.ConfigurationProvider provider = new DefaultConfigurationBuilder.ConfigurationProvider();
        this.factory.addConfigurationProvider("test", provider);
        Assert.assertSame((String)"Failed to remove provider", (Object)provider, (Object)this.factory.removeConfigurationProvider("test"));
        Assert.assertNull((String)"Provider still registered", (Object)this.factory.providerForTag("test"));
    }

    @Test
    public void testConfigurationBeanFactoryCreateBean() {
        this.factory.addConfigurationProvider("test", new DefaultConfigurationBuilder.ConfigurationProvider(PropertiesConfiguration.class));
        this.factory.addProperty("test[@throwExceptionOnMissing]", (Object)"true");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("test"));
        PropertiesConfiguration conf = (PropertiesConfiguration)BeanHelper.createBean((BeanDeclaration)decl);
        Assert.assertTrue((String)"Property was not initialized", (boolean)conf.isThrowExceptionOnMissing());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationBeanFactoryCreateUnknownTag() {
        this.factory.addProperty("test[@throwExceptionOnMissing]", (Object)"true");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("test"));
        BeanHelper.createBean((BeanDeclaration)decl);
    }

    @Test
    public void testLoadConfiguration() throws ConfigurationException {
        this.factory.setFile(TEST_FILE);
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromFile() throws ConfigurationException {
        this.factory = new DefaultConfigurationBuilder(TEST_FILE);
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromFileName() throws ConfigurationException {
        this.factory = new DefaultConfigurationBuilder(TEST_FILE.getAbsolutePath());
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromURL() throws Exception {
        this.factory = new DefaultConfigurationBuilder(TEST_FILE.toURI().toURL());
        this.checkConfiguration();
    }

    private void checkConfiguration() throws ConfigurationException {
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Number of configurations", (long)3L, (long)compositeConfiguration.getNumberOfConfigurations());
        Assert.assertEquals(PropertiesConfiguration.class, compositeConfiguration.getConfiguration(0).getClass());
        Assert.assertEquals(XMLPropertiesConfiguration.class, compositeConfiguration.getConfiguration(1).getClass());
        Assert.assertEquals(XMLConfiguration.class, compositeConfiguration.getConfiguration(2).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)compositeConfiguration.getConfiguration(0);
        Assert.assertNotNull((String)("Make sure we have a fileName: " + pc.getFileName()), (Object)pc.getFileName());
        this.checkProperties((Configuration)compositeConfiguration);
    }

    private void checkProperties(Configuration compositeConfiguration) {
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((String)"property in the XMLPropertiesConfiguration", (Object)"value1", (Object)compositeConfiguration.getProperty("key1"));
    }

    @Test
    public void testLoadAdditional() throws ConfigurationException {
        this.factory.setFile(ADDITIONAL_FILE);
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (long)2L, (long)compositeConfiguration.getNumberOfConfigurations());
        Object prop = compositeConfiguration.getProperty("tables.table.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)3L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"users", (Object)compositeConfiguration.getProperty("tables.table(0).name"));
        Assert.assertEquals((Object)"documents", (Object)compositeConfiguration.getProperty("tables.table(1).name"));
        Assert.assertEquals((Object)"tasks", (Object)compositeConfiguration.getProperty("tables.table(2).name"));
        prop = compositeConfiguration.getProperty("tables.table.fields.field.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)17L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"smtp.mydomain.org", (Object)compositeConfiguration.getString("mail.host.smtp"));
        Assert.assertEquals((Object)"pop3.mydomain.org", (Object)compositeConfiguration.getString("mail.host.pop"));
        Assert.assertEquals((Object)"masterOfPost", (Object)compositeConfiguration.getString("mail.account.user"));
        Assert.assertEquals((Object)"topsecret", (Object)compositeConfiguration.getString("mail.account.psswd"));
        Assert.assertEquals((Object)"enhanced factory", (Object)compositeConfiguration.getString("test.configuration"));
    }

    @Test
    public void testLogErrorListener() {
        Assert.assertEquals((String)"No default error listener registered", (long)1L, (long)new DefaultConfigurationBuilder().getErrorListeners().size());
    }

    @Test
    public void testLoadOptional() throws Exception {
        this.factory.setURL(OPTIONAL_FILE.toURI().toURL());
        Configuration config = this.factory.getConfiguration();
        Assert.assertTrue((boolean)config.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element"));
    }

    @Test
    public void testLoadOptionalErrorEvent() throws Exception {
        this.factory.clearErrorListeners();
        ConfigurationErrorListenerImpl listener = new ConfigurationErrorListenerImpl();
        this.factory.addErrorListener((ConfigurationErrorListener)listener);
        this.prepareOptionalTest("configuration", false);
        listener.verify(51, OPTIONAL_NAME, null);
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadOptionalWithException() throws ConfigurationException {
        this.factory.setFile(OPTIONALEX_FILE);
        this.factory.getConfiguration();
    }

    @Test
    public void testLoadOptionalNonFileBased() throws ConfigurationException {
        CombinedConfiguration config = this.prepareOptionalTest("configuration", false);
        Assert.assertTrue((String)"Configuration not empty", (boolean)config.isEmpty());
        Assert.assertEquals((String)"Wrong number of configurations", (long)0L, (long)config.getNumberOfConfigurations());
    }

    @Test
    public void testLoadOptionalForceCreate() throws ConfigurationException {
        this.factory.setBasePath(TEST_FILE.getParent());
        CombinedConfiguration config = this.prepareOptionalTest("xml", true);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)config.getNumberOfConfigurations());
        FileConfiguration fc = (FileConfiguration)config.getConfiguration(OPTIONAL_NAME);
        Assert.assertNotNull((String)"Optional config not found", (Object)fc);
        Assert.assertEquals((String)"File name was not set", (Object)"nonExisting.xml", (Object)fc.getFileName());
        Assert.assertNotNull((String)"Base path was not set", (Object)fc.getBasePath());
    }

    @Test
    public void testLoadOptionalBuilderForceCreate() throws ConfigurationException {
        CombinedConfiguration config = this.prepareOptionalTest("configuration", true);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Wrong optional configuration type", (boolean)(config.getConfiguration(OPTIONAL_NAME) instanceof CombinedConfiguration));
    }

    @Test
    public void testLoadOptionalForceCreateWithException() throws ConfigurationException {
        this.factory.addConfigurationProvider("test", (DefaultConfigurationBuilder.ConfigurationProvider)new DefaultConfigurationBuilder.ConfigurationBuilderProvider(){

            public AbstractConfiguration getEmptyConfiguration(DefaultConfigurationBuilder.ConfigurationDeclaration decl) throws Exception {
                throw new Exception("Unable to create configuration!");
            }
        });
        CombinedConfiguration config = this.prepareOptionalTest("test", true);
        Assert.assertEquals((String)"Optional configuration could be created", (long)0L, (long)config.getNumberOfConfigurations());
    }

    private CombinedConfiguration prepareOptionalTest(String tag, boolean force) throws ConfigurationException {
        String prefix = "override." + tag;
        this.factory.addProperty(prefix + "[@fileName]", (Object)"nonExisting.xml");
        this.factory.addProperty(prefix + "[@config-optional]", (Object)Boolean.TRUE);
        this.factory.addProperty(prefix + "[@config-name]", (Object)OPTIONAL_NAME);
        if (force) {
            this.factory.addProperty(prefix + "[@config-forceCreate]", (Object)Boolean.TRUE);
        }
        return this.factory.getConfiguration(false);
    }

    @Test
    public void testLoadOptionalChildBuilderSuppressErrorLog() throws ConfigurationException {
        this.factory.addProperty("override.configuration[@fileName]", (Object)OPTIONAL_FILE.getAbsolutePath());
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.startsWith("is")) {
                    return Boolean.TRUE;
                }
                if ("warn".equals(methodName)) {
                    Assert.fail((String)"Unexpected log output!");
                }
                return null;
            }
        };
        this.factory.setLogger((Log)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Log.class}, handler));
        this.factory.getConfiguration(false);
    }

    @Test
    public void testLoadDifferentSources() throws ConfigurationException {
        this.factory.setFile(MULTI_FILE);
        Configuration config = this.factory.getConfiguration();
        Assert.assertFalse((boolean)config.isEmpty());
        Assert.assertTrue((boolean)(config instanceof CombinedConfiguration));
        CombinedConfiguration cc = (CombinedConfiguration)config;
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)cc.getNumberOfConfigurations());
        Assert.assertNotNull((Object)config.getProperty("tables.table(0).fields.field(2).name"));
        Assert.assertNotNull((Object)config.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element3"));
        Assert.assertEquals((Object)"foo", (Object)config.getProperty("element3[@name]"));
        Assert.assertNotNull((Object)config.getProperty("mail.account.user"));
        Assert.assertNotNull((Object)config.getProperty("test.onlyinjndi"));
        Assert.assertTrue((boolean)config.getBoolean("test.onlyinjndi"));
        Configuration subset = config.subset("test");
        Assert.assertNotNull((Object)subset.getProperty("onlyinjndi"));
        Assert.assertTrue((boolean)subset.getBoolean("onlyinjndi"));
        Assert.assertNotNull((Object)config.getProperty("java.version"));
        Assert.assertEquals((Object)System.getProperty("java.version"), (Object)config.getString("java.version"));
        Assert.assertEquals((String)"Property from ini file not found", (Object)"yes", (Object)config.getString("testini.loaded"));
        EnvironmentConfiguration envConf = new EnvironmentConfiguration();
        Iterator it = envConf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String combinedKey = "env." + key;
            Assert.assertEquals((String)("Wrong value for env property " + key), (Object)envConf.getString(key), (Object)config.getString(combinedKey));
        }
    }

    @Test
    public void testSetConfigurationBasePath() throws ConfigurationException {
        this.factory.addProperty("properties[@fileName]", (Object)"test.properties");
        File deepDir = new File(ConfigurationAssert.TEST_DIR, "config/deep");
        this.factory.setConfigurationBasePath(deepDir.getAbsolutePath());
        CombinedConfiguration config = this.factory.getConfiguration(false);
        Assert.assertEquals((String)"Wrong property value", (Object)"somevalue", (Object)config.getString("somekey"));
    }

    @Test
    public void testComplexInitialization() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"System property not found", (Object)"test.xml", (Object)cc.getString("test_file_xml"));
        PropertiesConfiguration c1 = (PropertiesConfiguration)cc.getConfiguration(1);
        Assert.assertTrue((String)"Reloading strategy was not set", (boolean)(c1.getReloadingStrategy() instanceof FileChangedReloadingStrategy));
        Assert.assertEquals((String)"Refresh delay was not set", (long)10000L, (long)((FileChangedReloadingStrategy)c1.getReloadingStrategy()).getRefreshDelay());
        Configuration xmlConf = cc.getConfiguration("xml");
        Assert.assertEquals((String)"Property not found", (Object)"I'm complex!", (Object)xmlConf.getString("element2/subelement/subsubelement"));
        Assert.assertEquals((String)"List index not found", (Object)"two", (Object)xmlConf.getString("list[0]/item[1]"));
        Assert.assertEquals((String)"Property in combiner file not found", (Object)"yellow", (Object)cc.getString("/gui/selcolor"));
        Assert.assertTrue((String)"Delimiter flag was not set", (boolean)cc.isDelimiterParsingDisabled());
        Assert.assertTrue((String)"Expression engine was not set", (boolean)(cc.getExpressionEngine() instanceof XPathExpressionEngine));
    }

    @Test
    public void testCombinedConfigurationStructure() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertNotNull((String)"Properties configuration not found", (Object)cc.getConfiguration("properties"));
        Assert.assertNotNull((String)"XML configuration not found", (Object)cc.getConfiguration("xml"));
        Assert.assertEquals((String)"Wrong number of contained configs", (long)4L, (long)cc.getNumberOfConfigurations());
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        Assert.assertNotNull((String)"No additional configuration found", (Object)cc2);
        Set names = cc2.getConfigurationNames();
        Assert.assertEquals((String)"Wrong number of contained additional configs", (long)2L, (long)names.size());
        Assert.assertTrue((String)"Config 1 not contained", (boolean)names.contains("combiner1"));
        Assert.assertTrue((String)"Config 2 not contained", (boolean)names.contains("combiner2"));
    }

    private void checkCombinedConfigAttrs(CombinedConfiguration cc) {
        Assert.assertTrue((String)"Wrong delimiter parsing flag", (boolean)cc.isDelimiterParsingDisabled());
        Assert.assertTrue((String)"Wrong reload check", (boolean)cc.isForceReloadCheck());
        Assert.assertTrue((String)"Wrong ignore reload ex flag", (boolean)cc.isIgnoreReloadExceptions());
    }

    @Test
    public void testCombinedConfigurationAttributes() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        this.checkCombinedConfigAttrs(cc);
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        this.checkCombinedConfigAttrs(cc2);
    }

    @Test
    public void testCombinedConfigurationNoAdditional() throws ConfigurationException {
        this.factory.setFile(TEST_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Assert.assertNull((String)"Additional configuration was found", (Object)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME));
    }

    @Test
    public void testCombinedConfigurationListNodes() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Set listNodes = cc.getNodeCombiner().getListNodes();
        Assert.assertEquals((String)"Wrong number of list nodes", (long)2L, (long)listNodes.size());
        Assert.assertTrue((String)"table node not a list node", (boolean)listNodes.contains("table"));
        Assert.assertTrue((String)"list node not a list node", (boolean)listNodes.contains("list"));
        CombinedConfiguration cca = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        listNodes = cca.getNodeCombiner().getListNodes();
        Assert.assertTrue((String)"Found list nodes for additional combiner", (boolean)listNodes.isEmpty());
    }

    @Test
    public void testConfigurationBuilderProvider() throws ConfigurationException {
        this.factory.addProperty("override.configuration[@fileName]", (Object)TEST_FILE.getAbsolutePath());
        CombinedConfiguration cc = this.factory.getConfiguration(false);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)cc.getNumberOfConfigurations());
        this.checkProperties((Configuration)cc);
    }

    @Test
    public void testConfigurationBuilderProviderInheritProperties() throws Exception {
        this.factory.addProperty("override.configuration[@fileName]", (Object)TEST_FILE.getAbsolutePath());
        this.factory.setBasePath("conf");
        this.factory.setAttributeSplittingDisabled(true);
        this.factory.setDelimiterParsingDisabled(true);
        this.factory.setListDelimiter('/');
        this.factory.setThrowExceptionOnMissing(true);
        Log log = LogFactory.getLog(this.getClass());
        this.factory.setLogger(log);
        this.factory.clearErrorListeners();
        this.factory.clearConfigurationListeners();
        ConfigurationListenerTestImpl l = new ConfigurationListenerTestImpl(this.factory);
        this.factory.addConfigurationListener((ConfigurationListener)l);
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("override.configuration"));
        DefaultConfigurationBuilder.ConfigurationBuilderProvider provider = new DefaultConfigurationBuilder.ConfigurationBuilderProvider();
        DefaultConfigurationBuilder child = (DefaultConfigurationBuilder)provider.createBean(provider.fetchConfigurationClass(), (BeanDeclaration)decl, null);
        Assert.assertEquals((String)"Wrong base path", (Object)this.factory.getBasePath(), (Object)child.getBasePath());
        Assert.assertEquals((String)"Wrong attribute splitting flag", (Object)this.factory.isAttributeSplittingDisabled(), (Object)child.isAttributeSplittingDisabled());
        Assert.assertEquals((String)"Wrong delimiter parsing flag", (Object)this.factory.isDelimiterParsingDisabled(), (Object)child.isDelimiterParsingDisabled());
        Assert.assertEquals((String)"Wrong list delimiter", (long)this.factory.getListDelimiter(), (long)child.getListDelimiter());
        Assert.assertEquals((String)"Wrong exception flag", (Object)this.factory.isThrowExceptionOnMissing(), (Object)child.isThrowExceptionOnMissing());
        Assert.assertSame((String)"Wrong logger", (Object)log, (Object)child.getLogger());
        Assert.assertTrue((String)"Got error listeners", (boolean)child.getErrorListeners().isEmpty());
        Assert.assertEquals((String)"Wrong number of listeners", (long)1L, (long)child.getConfigurationListeners().size());
        Assert.assertEquals((String)"Wrong listener", (Object)l, child.getConfigurationListeners().iterator().next());
    }

    @Test
    public void testConfigurationBuilderProviderOverrideProperties() throws Exception {
        this.factory.addProperty("override.configuration[@fileName]", (Object)TEST_FILE.getAbsolutePath());
        this.factory.addProperty("override.configuration[@basePath]", (Object)"base");
        this.factory.addProperty("override.configuration[@throwExceptionOnMissing]", (Object)"false");
        this.factory.setBasePath("conf");
        this.factory.setThrowExceptionOnMissing(true);
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("override.configuration"));
        DefaultConfigurationBuilder.ConfigurationBuilderProvider provider = new DefaultConfigurationBuilder.ConfigurationBuilderProvider();
        DefaultConfigurationBuilder child = (DefaultConfigurationBuilder)provider.createBean(provider.fetchConfigurationClass(), (BeanDeclaration)decl, null);
        Assert.assertEquals((String)"Wrong base path", (Object)"base", (Object)child.getBasePath());
        Assert.assertFalse((String)"Wrong exception flag", (boolean)child.isThrowExceptionOnMissing());
    }

    @Test
    public void testLoadXMLWithSettings() throws Exception {
        File confDir = new File("conf");
        File targetDir = new File("target");
        File testXMLValidationSource = new File(confDir, "testValidateInvalid.xml");
        File testSavedXML = new File(targetDir, "testSave.xml");
        File testSavedFactory = new File(targetDir, "testSaveFactory.xml");
        URL dtdFile = this.getClass().getResource("/properties.dtd");
        String publicId = "http://commons.apache.org/test.dtd";
        XMLConfiguration config = new XMLConfiguration("testDtd.xml");
        config.setPublicID("http://commons.apache.org/test.dtd");
        config.save(testSavedXML);
        this.factory.addProperty("xml[@fileName]", (Object)testSavedXML.getAbsolutePath());
        this.factory.addProperty("xml(0)[@validating]", (Object)"true");
        this.factory.addProperty("xml(-1)[@fileName]", (Object)testXMLValidationSource.getAbsolutePath());
        this.factory.addProperty("xml(1)[@config-optional]", (Object)"true");
        this.factory.addProperty("xml(1)[@validating]", (Object)"true");
        this.factory.save(testSavedFactory);
        this.factory = new DefaultConfigurationBuilder();
        this.factory.setFile(testSavedFactory);
        this.factory.registerEntityId("http://commons.apache.org/test.dtd", dtdFile);
        this.factory.clearErrorListeners();
        Configuration c = this.factory.getConfiguration();
        Assert.assertEquals((String)"Wrong property value", (Object)"value1", (Object)c.getString("entry(0)"));
        Assert.assertFalse((String)"Invalid XML source was loaded", (boolean)c.containsKey("table.name"));
        testSavedXML.delete();
        testSavedFactory.delete();
    }

    @Test
    public void testExtendedClass() throws ConfigurationException {
        this.factory.setFile(CLASS_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Assert.assertEquals((Object)"Extended", (Object)cc.getProperty("test"));
        Assert.assertTrue((String)("Wrong result class: " + cc.getClass()), (boolean)(cc instanceof ExtendedCombinedConfiguration));
    }

    @Test
    public void testConfigurationProvider() throws ConfigurationException {
        this.factory.setFile(PROVIDER_FILE);
        this.factory.getConfiguration(true);
        DefaultConfigurationBuilder.ConfigurationProvider provider = this.factory.providerForTag("test");
        Assert.assertNotNull((String)"Provider 'test' not registered", (Object)provider);
    }

    @Test
    public void testExtendedXMLConfigurationProvider() throws ConfigurationException {
        this.factory.setFile(EXTENDED_PROVIDER_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        DefaultConfigurationBuilder.ConfigurationProvider provider = this.factory.providerForTag("test");
        Assert.assertNotNull((String)"Provider 'test' not registered", (Object)provider);
        Configuration config = cc.getConfiguration("xml");
        Assert.assertNotNull((String)"Test configuration not present", (Object)config);
        Assert.assertTrue((String)("Configuration is not ExtendedXMLConfiguration, is " + config.getClass().getName()), (boolean)(config instanceof ExtendedXMLConfiguration));
    }

    @Test
    public void testGlobalLookup() throws Exception {
        this.factory.setFile(GLOBAL_LOOKUP_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String value = cc.getInterpolator().lookup("test:test_key");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"test.value", (Object)value);
    }

    @Test
    public void testSystemProperties() throws Exception {
        this.factory.setFile(SYSTEM_PROPS_FILE);
        this.factory.getConfiguration(true);
        String value = System.getProperty("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testValidation() throws Exception {
        this.factory.setFile(VALIDATION_FILE);
        this.factory.getConfiguration(true);
        String value = System.getProperty("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testValidation3() throws Exception {
        System.getProperties().remove("Id");
        this.factory.setFile(VALIDATION3_FILE);
        CombinedConfiguration config = this.factory.getConfiguration(true);
        String value = config.getString("Employee/Name");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"John Doe", (Object)value);
        System.setProperty("Id", "1001");
        value = config.getString("Employee/Name");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"Jane Doe", (Object)value);
    }

    @Test
    public void testMultiTenentConfiguration() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenentConfiguration2() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.setProperty("Id", "1004");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenentConfiguration3() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        StringWriter writer = new StringWriter();
        WriterAppender app = new WriterAppender((Layout)new SimpleLayout(), (Writer)writer);
        Log log = LogFactory.getLog((String)"TestLogger");
        Logger logger = ((Log4JLogger)log).getLogger();
        logger.addAppender((Appender)app);
        logger.setLevel(Level.DEBUG);
        logger.setAdditivity(false);
        System.setProperty("Id", "1005");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        String xml = writer.getBuffer().toString();
        Assert.assertNotNull((String)"No XML returned", (Object)xml);
        Assert.assertTrue((String)"Incorect configuration data", (xml.indexOf("<rowsPerPage>15</rowsPerPage>") >= 0 ? 1 : 0) != 0);
        logger.removeAppender((Appender)app);
        logger.setLevel(Level.OFF);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenantConfigurationAt() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.setProperty("Id", "1001");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        SubnodeConfiguration sub1 = config.configurationAt("Channels/Channel[@id='1']");
        Assert.assertEquals((Object)"My Channel", (Object)sub1.getString("Name"));
        Assert.assertEquals((Object)"test 1 data", (Object)sub1.getString("ChannelData"));
        SubnodeConfiguration sub2 = config.configurationAt("Channels/Channel[@id='2']");
        Assert.assertEquals((Object)"Channel 2", (Object)sub2.getString("Name"));
        Assert.assertEquals((Object)"more test 2 data", (Object)sub2.getString("MoreChannelData"));
    }

    @Test
    public void testMerge() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.setProperty("Id", "1004");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("default", "${colors.header4}");
        map.put("background", "#40404040");
        map.put("text", "#000000");
        map.put("header", "#444444");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        List list = config.configurationsAt("colors/*");
        for (SubnodeConfiguration sub : list) {
            String value;
            ConfigurationNode node = sub.getRootNode();
            String string = value = node.getValue() == null ? "null" : node.getValue().toString();
            if (!map.containsKey(node.getName())) continue;
            Assert.assertEquals(map.get(node.getName()), (Object)value);
        }
    }

    @Test
    public void testDelimiterParsingDisabled() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.setProperty("Id", "1004");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        Assert.assertEquals((Object)"a,b,c", (Object)config.getString("split/list3/@values"));
        Assert.assertEquals((long)0L, (long)config.getMaxIndex("split/list3/@values"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)config.getString("split/list4/@values"));
        Assert.assertEquals((Object)"a,b,c", (Object)config.getString("split/list1"));
        Assert.assertEquals((long)0L, (long)config.getMaxIndex("split/list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)config.getString("split/list2"));
    }

    @Test
    public void testExpression() throws Exception {
        if (SystemUtils.isJavaVersionAtLeast((int)150)) {
            this.factory.setFile(EXPRESSION_FILE);
            this.factory.setAttributeSplittingDisabled(true);
            System.getProperties().remove("Id");
            MDC.clear();
            CombinedConfiguration config = this.factory.getConfiguration(true);
            Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
            this.verify("1001", config, 15);
        }
    }

    @Test
    public void testInterpolationOverMultipleSources() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testInterpolationBuilder.xml");
        this.factory.setFile(testFile);
        CombinedConfiguration combConfig = this.factory.getConfiguration(true);
        Assert.assertEquals((String)"Wrong value", (Object)"abc-product", (Object)combConfig.getString("products.product.desc"));
        XMLConfiguration xmlConfig = (XMLConfiguration)combConfig.getConfiguration("test");
        Assert.assertEquals((String)"Wrong value from XML config", (Object)"abc-product", (Object)xmlConfig.getString("products/product/desc"));
        SubnodeConfiguration subConfig = xmlConfig.configurationAt("products/product[@name='abc']", true);
        Assert.assertEquals((String)"Wrong value from sub config", (Object)"abc-product", (Object)subConfig.getString("desc"));
    }

    private void verify(String key, CombinedConfiguration config, int rows) {
        System.setProperty("Id", key);
        MDC.put((String)"Id", (String)key);
        int actual = config.getInt("rowsPerPage");
        Assert.assertTrue((String)("expected: " + rows + " actual: " + actual), (actual == rows ? 1 : 0) != 0);
    }

    public static class TestLookup
    extends StrLookup {
        Map<String, String> map = new HashMap<String, String>();

        public TestLookup() {
            this.map.put("test_file_xml", "test.xml");
            this.map.put("test_file_combine", "testcombine1.xml");
            this.map.put("test_key", "test.value");
        }

        public String lookup(String key) {
            if (key == null) {
                return null;
            }
            return this.map.get(key);
        }
    }

    public static class ExtendedXMLConfiguration
    extends XMLConfiguration {
        private static final long serialVersionUID = 1L;
    }

    public static class ExtendedCombinedConfiguration
    extends CombinedConfiguration {
        private static final long serialVersionUID = 4678031745085083392L;

        public Object getProperty(String key) {
            if (key.equals("test")) {
                return "Extended";
            }
            return super.getProperty(key);
        }
    }
}

