/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.election;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.util.TimeDuration;

public class TransferCommand
extends AbstractRatisCommand {
    public static final String ADDRESS_OPTION_NAME = "address";
    public static final String TIMEOUT_OPTION_NAME = "timeout";

    public TransferCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "transfer";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        String strAddr = cl.getOptionValue(ADDRESS_OPTION_NAME);
        TimeDuration timeoutDefault = TimeDuration.ZERO;
        TimeDuration timeoutLegacy = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);
        Optional<TimeDuration> timeout = !cl.hasOption(TIMEOUT_OPTION_NAME) ? Optional.empty() : Optional.of(TimeDuration.valueOf((String)cl.getOptionValue(TIMEOUT_OPTION_NAME), (TimeUnit)TimeUnit.SECONDS));
        int highestPriority = this.getRaftGroup().getPeers().stream().mapToInt(RaftPeer::getPriority).max().orElse(0);
        RaftPeer newLeader = this.getRaftGroup().getPeers().stream().filter(peer -> peer.getAddress().equals(strAddr)).findAny().orElse(null);
        if (newLeader == null) {
            this.printf("Peer with address %s not found.", strAddr);
            return -2;
        }
        try (RaftClient client = RaftUtils.createClient(this.getRaftGroup());){
            if (!this.tryTransfer(client, newLeader, highestPriority, timeout.orElse(timeoutDefault))) {
                this.tryTransfer(client, newLeader, highestPriority + 1, timeout.orElse(timeoutLegacy));
            }
        }
        catch (Throwable t) {
            this.printf("Failed to transfer to peer %s with address %s: ", newLeader.getId(), newLeader.getAddress());
            t.printStackTrace(this.getPrintStream());
            return -1;
        }
        return 0;
    }

    private boolean tryTransfer(RaftClient client, RaftPeer newLeader, int highestPriority, TimeDuration timeout) throws IOException {
        this.printf("Transferring leadership to peer %s with address %s%n", newLeader.getId(), newLeader.getAddress());
        try {
            if (newLeader.getPriority() < highestPriority) {
                this.setPriority(client, newLeader, highestPriority);
            }
            RaftClientReply transferLeadershipReply = client.admin().transferLeadership(newLeader.getId(), timeout.toLong(TimeUnit.MILLISECONDS));
            this.processReply(transferLeadershipReply, () -> "election failed");
        }
        catch (TransferLeadershipException tle) {
            if (tle.getMessage().contains("it does not has highest priority")) {
                return false;
            }
            throw tle;
        }
        this.println("Transferring leadership initiated");
        return true;
    }

    private void setPriority(RaftClient client, RaftPeer target, int priority) throws IOException {
        this.printf("Changing priority of peer %s with address %s to %d%n", target.getId(), target.getAddress(), priority);
        List peers = this.getPeerStream(RaftProtos.RaftPeerRole.FOLLOWER).map(peer -> peer == target ? RaftPeer.newBuilder((RaftPeer)peer).setPriority(priority).build() : peer).collect(Collectors.toList());
        List listeners = this.getPeerStream(RaftProtos.RaftPeerRole.LISTENER).collect(Collectors.toList());
        RaftClientReply reply = client.admin().setConfiguration(peers, listeners);
        this.processReply(reply, () -> "Failed to set master priorities");
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <HOSTNAME:PORT> -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>] [-%s <TIMEOUT_IN_SECONDS>]", this.getCommandName(), ADDRESS_OPTION_NAME, "peers", "groupid", TIMEOUT_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return TransferCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(ADDRESS_OPTION_NAME).hasArg().required().desc("Server address that will take over as leader").build()).addOption(Option.builder().option(TIMEOUT_OPTION_NAME).hasArg().desc("Timeout for transfer leadership to complete (in seconds)").build());
    }

    public static String description() {
        return "Transfers leadership to the <hostname>:<port>";
    }
}

